/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

// gentee!!!

type BITMAPFILEHEADER 
{ 
  ushort    bfType 
  uint      bfSize 
  ushort    bfReserved1 
  ushort    bfReserved2 
  uint      bfOffBits 
}

define
{
   CAPTUREBLT = 0x40000000
   SRCCOPY    = 0x00CC0020
}

// gentee!!!
func savebmp( str filename, uint hbmp )
{
   uint              hdc 
   uint size
	BITMAPINFO			bmpInfo
	BITMAPFILEHEADER	bmpFileHeader
   buf               bmpbuf

//	do{

   hdc = GetDC( 0 )
   bmpInfo.bmiHeader.bmiSize = sizeof( BITMAPINFOHEADER )
	GetDIBits( hdc, hbmp, 0, 0, 0, bmpInfo, 0 /*$DIB_RGB_COLORS*/ )

	bmpInfo.bmiHeader.bmiBitCount = 24//$BITSPERPIXEL
	if bmpInfo.bmiHeader.bmiSizeImage <= 0
   {
		bmpInfo.bmiHeader.bmiSizeImage = bmpInfo.bmiHeader.bmiWidth * 
         abs( bmpInfo.bmiHeader.bmiHeight ) * 
           ( bmpInfo.bmiHeader.bmiBitCount + 7 ) / 8
   }
   size = bmpInfo.bmiHeader.bmiSizeImage + sizeof( BITMAPFILEHEADER ) +
                    sizeof( BITMAPINFOHEADER );
   bmpbuf.reserve( size )
   bmpbuf.use = size
	bmpInfo.bmiHeader.bmiCompression = 0 // $BI_RGB

   GetDIBits( hdc, hbmp, 0, bmpInfo.bmiHeader.bmiHeight, bmpbuf.ptr() +
              sizeof( BITMAPFILEHEADER ) + sizeof( BITMAPINFOHEADER ), 
              bmpInfo, 0 /*$DIB_RGB_COLORS*/ )	

	bmpFileHeader.bfReserved1=0
	bmpFileHeader.bfReserved2=0
	bmpFileHeader.bfSize = size
	bmpFileHeader.bfType = 0x4D42
	bmpFileHeader.bfOffBits = sizeof( BITMAPFILEHEADER ) + 
                                  sizeof(BITMAPINFOHEADER)

   mcopy( bmpbuf.ptr(), &bmpFileHeader, sizeof( BITMAPFILEHEADER ))   
   mcopy( bmpbuf.ptr() + sizeof( BITMAPFILEHEADER ), &bmpInfo.bmiHeader, 
             sizeof( BITMAPINFOHEADER ))
   bmpbuf.write( filename )   

   if hdc :	ReleaseDC( 0, hdc )
}
