/******************************************************************************
*
* Copyright (C) 2004-2007, The Gentee Group. All rights reserved. 
* This file is part of the Gentee open source project - http://www.gentee.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE GENTEE LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

// gentee!!!
include : "csv.g"

define 
{
   CSV_BUFSIZE = 200000
}

type csvfile <inherit = file index = arrstr>
{
   byte  csepar  
   byte  copen    
   byte  cclose
   long  size
}

type csvfilefordata <inherit=fordata>
{
   csv        cur
   csvfordata fdcsv
   long       off
}

method csvfile csvfile.init()
{
   this.copen = this.cclose = '"'
   this.csepar = ','  
   return this
} 

method csvfile.settings( uint separ, uint open, uint close )
{
   this.csepar = separ
   this.copen  = open
   this.cclose = close      
}

method uint file.setpos( long offset, uint mode )
{
   if .fopen
   {
      uint low = uint( offset )
      uint hi = uint( ( offset >> 32L ))
      return SetFilePointer( .handle, low, &hi, mode )
   }
   return 0
}

method long file.getlongsize
{
   uint high low
   
   low = GetFileSize( .handle, &high )
   
   return long( low ) | ( long( high ) << 32L )
}

method uint csvfile.open( str filename )
{
   uint ret
   
   .size = 0L
   if ret = .open( filename, $OP_READONLY )
   {
      .size = .getlongsize()
   }
   return ret
}

method csvfile.deinit()
{
   .close()    
} 


method uint csvfile.load( csvfilefordata fd )
{
   uint read right
     
   if fd.off >= .size : return 0
   
   if .size - fd.off > long( $CSV_BUFSIZE ) : read = $CSV_BUFSIZE 
   else : read = uint( .size - fd.off )
   
   fd.cur.reserve( $CSV_BUFSIZE + 1 )
   .setpos( fd.off, $FILE_BEGIN )
   read = .read( fd.cur.ptr(), read )
   fd.cur.setlen( read )
   right = fd.cur.findchr( 0xa ) + 1
   fd.cur.setlen( right  )
   fd.off += long( right ) 
    
//   fd.fdcsv.flgeof = 0   
//   fd.fdcsv.icur = 0   
   return 1   
}

method uint csvfile.next( csvfilefordata fd )
{  
   uint ret    
   
   ret = fd.cur.next( fd.fdcsv )
   if fd.fdcsv.flgeof && .load( fd )
   { 
      ret = fd.cur.first( fd.fdcsv )
   }
   return ret
}

method uint csvfile.first( csvfilefordata fd )
{   
   fd.off = 0L
   .load( fd )
   return fd.cur.first( fd.fdcsv )   
}

method uint csvfile.eof( csvfilefordata fd )
{  
   return fd.fdcsv.flgeof    
}
/*
func main<main>
{
   csvfile csvf
   uint    i 
   str     out
      
   csvf.open("test.csv")
   foreach cur, csvf
   {
      uint k
      str  line = cur[0]
      fornum k, 10
      { 
         if k & 1 : line += ",\"\( cur[k + 1] )\""
         else : line += ",\( cur[k + 1] )"
      }
//      print("\(i++) \( *cur )\n ")
      out += "\(line)\l"
   }
   out.write("newtest.csv") 
   congetch("Press any key")
}
*/
