/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

define
{
   MESSAGE = $WM_USER + 100
   MESSAGEOK
   AUTOBTN
   CMD_OUTNEW
   CMD_OUT
   CMD_SHOWHIDE
   CMD_BUTTONS
   CMD_TASKSTATE
   CMD_AUTOCLOSE
   
   MSG_HAND = 1
   MSG_NOTE
   MSG_QUEST
   MSG_INFORM
}

type taskstateinfo
{
   ustr caption
   uint left
   uint top
   uint width
   uint height
   uint state
}

type autoinf
{
   uint ctrl
   uint wait
   uint time
   str  caption
   uint run
}

global
{
   hash    autobtn of autoinf
   uint    pressed
}

func waitform( str retmacro )
{
   uint state sec tick = 3
   str  ret
   
   if IsIconic( mainwnd ) : state = $SW_MINIMIZE + 1
   elif !IsWindowVisible( mainwnd ) : state = $SW_HIDE + 1
   if state : ShowWindow( mainwnd, $SW_RESTORE )
   logwait = 1
   while logwait
   { 
      if ++tick == 4 && !pressed
      {
         foreach cura,autobtn
         {
            if !cura.ctrl : continue
            if sec < cura.wait
            {
               cura.time = cura.wait - sec 
               SendMessage( mainwnd, $WM_COMMAND, $AUTOBTN, &cura )
            }
            else
            {  
               cura.run = 1
               cura.time = 0
               SendMessage( mainwnd, $WM_COMMAND, $AUTOBTN, &cura )
            }
         }
         tick = 0
         sec++          
      }  
      elif pressed == 1
      { 
         foreach cura,autobtn
         {
            if !cura.ctrl : continue
            cura.time = 0
            SendMessage( mainwnd, $WM_COMMAND, $AUTOBTN, &cura )
         }
         pressed++
      }
      Sleep( 250 )
   }
   defmacro.get( retmacro, ret )
   retmacro = ret
   if state : ShowWindow( mainwnd, state - 1 )
}

func message( uint icon, str outtext, collection btns, str retmacro )
{
   str buttons temp msgtext
   arrstr lines
   uint i

   if &btns
   {
      buttons = "<btns label=ctrlitem ctrl=buttons labpos=center itemwidth = 100 >
       <items >\l"
      fornum i, *btns
      {
         if *btns[i]->str
         {
            str slabel
            uint width
            if defmacro.ismacro(btns[i]->str)
            {
               defmacro.get( btns[i]->str, slabel )
            }
            else : slabel = btns[i]->str
            width = uint( defmacro.getint("\( btns[i]->str )_xwidth"))  
            buttons += "<\( btns[i]->str ) label = \"\( slabel )\" \(?( width, 
                         "width=\(width)","" ))></>\l"
         }  
      }
      buttons += "</>
      </>"
   }
   defmacro.replace( outtext )
   lines.loadtrim( outtext )
   ustr( outtext ).toutf8( msgtext )
   temp = "<msg>
<fields>
    <text label=text req=0 ctrl=text image=\"resource\\#\(255 + icon)\" labpos=left lines = \( max( 2, *lines*2/3 + 1 ))>
         \( msgtext )
    </>
    \(buttons)
</fields>
</msg>
<msgval>
     <text></>
     <btns></>
</>
"
   defmacro.set( "gtmsg", temp )
   if !*retmacro : retmacro = "msgret"
   defmacro.set( "retmsg", retmacro )
   logwait = 1
   SendMessage( mainwnd, $WM_COMMAND, $MESSAGE, 0 )
   if &btns
   {
      waitform( retmacro )   
   }
}

func messagenfy( uint icon, str outtext )
{
   if *outtext
   {
      message( icon, outtext, 0->collection, "msgret" )
   }
   else : PostMessage( mainwnd, $WM_COMMAND, $MESSAGEOK, 0 )
}

func messagecmd( uint icon, str outtext, str retmacro, collection btns, 
                 uint dataoff )
{
   uint   ptr i count
   arrstr buttons
   
   count = getlistptr( dataoff, &ptr )
   fornum i, count
   {
      str name
      getlistval( name, &ptr )
      buttons += name
      btns.append( &buttons[ *buttons - 1 ], str )
   }
   message( icon, outtext, btns, retmacro ) 
}