/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

type LUID 
{
   uint LowPart
   uint HighPart
}

type LUID_AND_ATTRIBUTES 
{
   LUID Luid
   uint Attributes
}

type TOKEN_PRIVILEGES 
{
   uint                PrivilegeCount
   LUID_AND_ATTRIBUTES Privileges
}

import "advapi32.dll"
{
   uint AdjustTokenPrivileges( uint, uint, uint, uint, uint, uint )
   uint LookupPrivilegeValueA( uint, uint, LUID ) -> LookupPrivilegeValue
   uint OpenProcessToken( uint, uint, uint )
}

import "user32.dll"
{
   uint ExitWindowsEx( uint, uint )
}

import "kernel32.dll"
{
   uint GetCurrentProcess()
//   uint GetShortPathNameA( uint, uint, uint ) -> GetShortPathName 
   uint HeapAlloc( uint, uint, uint )
   uint GetProcessHeap()
   uint HeapFree( uint, uint, uint )
}

define
{
   TOKEN_QUERY = 0x0008
   TOKEN_ADJUST_PRIVILEGES = 0x0020
   SE_PRIVILEGE_ENABLED    = 0x00000002
   SE_SHUTDOWN_NAME = "SeShutdownPrivilege"
   
   EWX_SHUTDOWN       =  0x00000001
   EWX_REBOOT         =  0x00000002
   EWX_FORCE          =  0x00000004
   EWX_POWEROFF       =  0x00000008
   
   DEFEXIT = 2000
}


func rebootNT
{
   uint             hToken 
   uint             mem tkp 
//   TOKEN_PRIVILEGES tkp 

   if defver.platform < 2 : return

   mem = HeapAlloc( GetProcessHeap(), 0x00000008, 512 )
   tkp as mem->TOKEN_PRIVILEGES
   
   if !OpenProcessToken( GetCurrentProcess(), 
        $TOKEN_ADJUST_PRIVILEGES | $TOKEN_QUERY, &hToken ) : return
 
   LookupPrivilegeValue( 0, $SE_SHUTDOWN_NAME.ptr(), tkp.Privileges.Luid ) 
   
   tkp.PrivilegeCount = 1  // one privilege to set    
   tkp.Privileges.Attributes = $SE_PRIVILEGE_ENABLED; 
 
   AdjustTokenPrivileges( hToken, 0, &tkp, 0, 0, 0 )
   HeapFree( GetProcessHeap(), 0, mem )
} 

