/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

import "user32.dll"
{
   uint EnumChildWindows( uint, uint, uint )
   uint EnumWindows( uint, uint )
   uint FindWindowW( uint, uint ) -> FindWindow
   uint GetWindowThreadProcessId( uint, uint )
}


func str getclasstext( uint hwnd, str ret )
{  //    vEdit 
   ustr pText
   
   pText.reserve( 256 )
   GetClassName( hwnd, pText.ptr(), 256 )    
   pText.setlenptr()
   return ret = pText
}

//--------------------------------------------------------------------------

func uint winenum( uint wnd, uint idfunc, uint param )
{
   uint  ret
   uint  callfunc = callback( idfunc, 2 )

   if wnd : ret = EnumChildWindows( wnd, callfunc, param )
   else : ret = EnumWindows( callfunc, param )
   
   freecallback( callfunc )
   return ret
}

type PROCESSENTRY32 { 
  uint dwSize 
  uint cntUsage 
  uint th32ProcessID 
  uint th32DefaultHeapID 
  uint th32ModuleID 
  uint cntThreads
  uint th32ParentProcessID 
  uint pcPriClassBase 
  uint dwFlags 
  reserved szExeFile[ 260 ]; 
} 

import "kernel32.dll"
{
   uint TerminateProcess( uint, uint )
   uint OpenProcess( uint, uint, uint )
   uint CreateToolhelp32Snapshot( uint, uint )
   uint Process32First( uint, PROCESSENTRY32 )
   uint Process32Next( uint, PROCESSENTRY32 )
}

define
{
   PROCESS_TERMINATE = 0x0001
   TH32CS_SNAPPROCESS = 0x00000002 
}

type twinmatch
{
   str name
   str match
   str class
   str var
   uint state
   uint hidden
}

func uint winmatch( uint wnd, twinmatch twin )
{
   str stemp class
   uint cns
   
   if !GetWindow( wnd, 5 /*$GW_CHILD*/ ) || *twin.class
   {
      getclasstext( wnd, class )
   } 
   getwintext( wnd, stemp )
   if *stemp && ( twin.hidden || IsWindowVisible( wnd  )) && 
       GetWindow( wnd, 2 /*$GW_HWNDNEXT*/ ) &&
       ( GetWindow( wnd, 5 /*$GW_CHILD*/ ) ||  IsIconic( wnd ) ||
         class %== "ConsoleWindowClass" ) &&
      !GetParent( wnd )   
   {
      if *twin.class 
      {
         if twin.class %!= class : return 0 
      }
      switch ( twin.match )
      {
         case "exact"
         {
            if twin.name %!= stemp : return 0
         }
         case "substr"
         {
            if !stemp.search( twin.name, $QS_IGNCASE ) : return 0
         }
         case "wildcard"
         {
            if !stemp.fwildcard( twin.name ) : return 0    
         }
         default : return 0
      }
      return 1 
   }
   return 0
}
