/******************************************************************************
*
* Copyright (C) 2009, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

include : $"..\libs\cab\cab.g"

type  cabdeuser
{
   uint    logout
   arrstr  files
}

func uint cabde_notify( uint code, str param, decabinfo decab )
{
   uint du = decab.param
   
   du as cabdeuser
   switch code
   {
      case $FLN_ERROR
      { 
         messagecmd( $MSG_HAND, param, "msgret", %{ "ok" }, 0xFFFFFFFF )   
      }
      case $FLN_ERROPEN
      {
         str  stemp
         
         messagecmd( $MSG_HAND, "Cannot open file \( param )", 
                        "msgret", %{ "retry", "abort" }, 0xFFFFFFFF )   
         
         defmacro.get("msgret", stemp )
         
         return stemp %== "retry"
      }
      case $FLN_NOTVALID
      {
         messagecmd( $MSG_HAND, "File \( param ) is not a cabinet archive!\n", 
                      "msgret", %{ "ok" }, 0xFFFFFFFF )   
      }
      case $FLN_FILEBEGIN
      {
         str stemp
         uint  ok
         
         stemp.fgetdir( decab.destfile )
         verifypath( stemp, 0->arrstr )
         decab.percent = 0
         decab.cursize = 0   
         foreach cur, du.files 
         {
            if decab.fileinfo->finfo.name.fwildcard( cur )
            {
               ok = 1
               break
            }
         } 
         if !ok : return 0
         if fileexist( decab.destfile )
         {
            setattribnormal( decab.destfile )
            deletefile( decab.destfile )
         }
         if du.logout
         { 
            outtext( 
            "CAB decoding: \(decab.fileinfo->finfo.fullname) => \( decab.destfile )")
         }
         return 1
      }
      case $FLN_PROGRESS
      {
         uint percent
         
         decab.cursize += &param;
         percent = min( 100, uint( 100.0 * double( decab.cursize ) / 
                                 double( decab.fileinfo->finfo.sizelo )));
         if percent > decab.percent
         { 
            decab.percent = percent
//            print( " \( percent )%")
         }
      }
      case $FLN_FILEEND
      {
         if du.logout
         { 
            outtextset( "CAB decoded: \( 
                   decab.fileinfo->finfo.fullname) => \( decab.destfile ) OK")
         }
      }
   }
   return 0
}
 

func uint cabcmd_decode( str cabfile dest wildcard, uint logout  )
{
   cabdeuser du
   
   defmacro.replace( cabfile )
   defmacro.replace( dest )
   defmacro.replace( wildcard )
   
   du.logout = logout
     
   if !*wildcard : wildcard = "*.*"
   
   wildcard.split( du.files, ';', $SPLIT_NOSYS )
   if *du.files < 2 : wildcard.split( du.files, ',', $SPLIT_NOSYS )
   if du.logout : outtext( "CAB: \( cabfile )")
   return cab_decode( cabfile, dest, &cabde_notify, &du )
}