/******************************************************************************
*
* Copyright (C) 2009, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

include : $"..\libs\cab\cab.g"

global
{
   uint caben_log 
}

func uint caben_notify( uint code, str param, cabinfo cabi )
{
   switch code
   {
      case $FLN_ERROR
      {
         messagecmd( $MSG_HAND, param, "msgret", %{ "ok" }, 0xFFFFFFFF )   
      }
      case $FLN_FILEBEGIN
      {
         if caben_log : outtext( "CAB encoding: \(param)")
        
         cabi.cabsize = 0
         cabi.percent = 0
      }
      case $FLN_PROGRESS
      {
/*         uint percent
          
         cabi.cabsize += &param
         percent = uint( 100.0 * double( cabi.cabsize ) / double( cabi.filesize ));
         percent = min( 100, percent )
         if percent > cabi.percent
         { 
            cabi.percent = percent
            print( " \( percent )%")
         }*/
      }
      case $FLN_FILEEND
      {
         if caben_log : outtextset( "CAB encoded: \(param) OK")
      }
      case $FLN_ERROPEN
      {
         str  stemp
         
         messagecmd( $MSG_HAND, "Cannot open file \( param )", 
                        "msgret", %{ "retry", "abort" }, 0xFFFFFFFF )   
         
         defmacro.get("msgret", stemp )
         
         return stemp %== "retry"
      }
   }
   return 0
}


func uint cabcmd_encode( str dest ignore volsize, uint logout ratio dataoff )
{
   uint    ptr i count
   arrstr  files
   arr     flags of uint
   
   count = getlistptr( dataoff, &ptr )
   if !count : return 0

   defmacro.replace( dest )
   defmacro.replace( ignore )
   defmacro.replace( volsize )
   
   fornum i, count
   {
      str  value
      uint flag
      
      getlistval( value, &ptr )
      defmacro.replace( value )
      files += value
      getlistval( value, &ptr )
      flag = ?( uint( value ), $FL_RECURSIVE, 0 )
      getlistval( value, &ptr )
      flag |= ?( uint( value ), $FL_FILES, 0 )
      flags += flag
   }   
   cabinit cabi
   
   caben_log = logout  
   if *ignore
   {
      ignore.split( cabi.exclude, ';', $SPLIT_NOSYS )
      if *cabi.exclude < 2 : ignore.split( cabi.exclude, ',', $SPLIT_NOSYS )
   }
   cabi.notify = &caben_notify
   cabi.level = ratio
   if uint( volsize ) 
   {        
      cabi.volumesize = max( 50, uint( volsize )) * 1024
   }   
   if caben_log : outtext( "CAB: \(dest)")
   return cab_create( dest, files, flags, cabi )
}