/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

include : "..\\libs\\clipboard.g"
include : "..\\libs\\keyboard.g"

// gentee!!!

import "user32.dll"
{
   uint EnumClipboardFormats( uint )
}

import "kernel32.dll"
{
   uint GlobalSize( uint )
}

func clip_save( str path filename, uint onlytext )
{
   str  outfile
   uint format count
   buf  out
   
   if !*filename : return
   
   ( outfile = path ).faddname( filename )
   defmacro.replace( outfile )
   
   if onlytext
   {
      str data
      
      clipboard_gettext( data )
      data.write( outfile )
      return  
   }
   OpenClipboard( 0 )
   out += 0x434150
   out += 0
   while format = EnumClipboardFormats( format )
   {
      uint hmem ptr size
      
      if hmem = GetClipboardData( format )
      {
         ptr = GlobalLock( hmem )
         size = GlobalSize( hmem )
         out += format
         out += size
         out.append( ptr, size )
         GlobalUnlock( ptr )
         count++      
      }
   }
   ( out.ptr() + 4 )->uint = count
   out.write( outfile )
   CloseClipboard()
}

func clip_load( str filename, uint subst )
{
   uint format count i ptr
   buf  in
   
   if !*filename : return
   
   defmacro.replace( filename )
   in.read( filename )
   if in.ptr()->uint != 0x434150
   {
      str data
      
      data.copy( in.ptr() )
      if subst : defmacro.replace( data )
      clipboard_settext( data )
      return
   }   
   OpenClipboard( 0 )
   EmptyClipboard()
   count = ( in.ptr() + 4 )->uint
   ptr = in.ptr() + 8
   fornum i, count
   {
      uint hmem size ptrmem
      
      if ptr >= in.ptr() + *in : break
      format = ptr->uint
      size = ( ptr + 4 )->uint      
      
      hmem = GlobalAlloc( $GMEM_MOVEABLE, size )
      if ptrmem = GlobalLock( hmem )
      {
         mcopy( ptrmem, ptr + 8, size )
         SetClipboardData( format, hmem )
      }   
      GlobalUnlock( hmem )
//      GlobalFree( hmem )
      ptr += 8 + size
   }
   CloseClipboard()
}

func clip_copy( uint mode )
{
   uint key
   
   key = ?( mode, $VK_INSERT, 'C' )
   sendvkey( key, $SVK_CONTROL )
}

func clip_paste( uint mode )
{
   if mode : sendvkey( $VK_INSERT, $SVK_SHIFT )
   else : sendvkey( 'V', $SVK_CONTROL )
}

func clip_gettext( str varname )
{
   str stemp
   
   clipboard_gettext( stemp )
   defmacro[ varname ] = ustr( stemp )
}

func clip_settext( str in )
{
   str stemp
   
   defmacro.replace( in )
   clipboard_settext( in )
}