/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

include : "..\\libs\\winproc.g"

func uint closewin( uint wnd, str name )
{
   str stemp
   
   getwintext( wnd, stemp )
   if stemp.search( name, $QS_IGNCASE )
   {
      SendMessage( wnd, $WM_CLOSE, 0, 0 )
   } 
   return 1
}

func uint close( str closetype, str name )
{
   uint ret prid
   ustr utemp
   
   defmacro.replace( name )
   switch closetype
   {
      case "winname"
      {
         utemp = name 
         if ret = FindWindow( 0, utemp.ptr())
         {
            SendMessage( ret, $WM_CLOSE, 0, 0 )
//               ret = GetWindowThreadProcessId( ret, &prid )
         }
      }
      case "subwin"
      {
         winenum( 0, &closewin, &name )
      }
      case "process"
      {
         uint  snap
         PROCESSENTRY32  pentry
            
         snap = CreateToolhelp32Snapshot( $TH32CS_SNAPPROCESS, 0 )
         if snap != 0xFFFFFFFF 
         {
            pentry.dwSize = sizeof( PROCESSENTRY32 )
            
            if Process32First( snap, pentry )
            {  
               do
               {  
                  str exefile
                  exefile.copy( &pentry.szExeFile )
                  if name %== exefile
                  {
                     prid = OpenProcess( $PROCESS_TERMINATE, 0, 
                                         pentry.th32ProcessID )
                     TerminateProcess( prid, 1 )
                     CloseHandle( prid )
//                     break
                  }
               } while Process32Next( snap, pentry ) 
            }
            CloseHandle( snap )
         }
      }
   }
   return ret
}
