/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

define 
{
   COPY_ALL = 0
   COPY_NEWER
   COPY_NEW
   COPY_DIF
   
   CMD_RELPATH  = 0x0001 

}

func uint copycmd( str filename dest ignore, uint cpytype cpyflag copybody )
{
   str ret 
   arrstr wcard
   ffind fd
   uint skipall
   uint  flag = $FIND_FILE
   str  temp destname srcdir
   
   if !*filename || !*dest  : return 0
   
   defmacro.replace( filename )
   defmacro.replace( dest )
   defmacro.replace( ignore )
   
//   if !( cpyflag & $CPYCMD_FILES ) : flag |= $FIND_DIR
   if cpyflag & $CMD_RECURSIVE : flag |= $FIND_RECURSE
      
   if *ignore : ignore.split( wcard, ',', $SPLIT_NOSYS )
   
   dest.ffullname( dest )
   filename.ffullname( filename )
   
   if direxist( filename )
   {
      temp.fnameext( filename )
      dest.faddname( temp )
      filename.faddname( "*.*" )
      flag |= $FIND_RECURSE
   }
   srcdir.fgetdir( filename )
      
   fd.init( filename, flag )
   foreach cur, fd
   {
      uint ok skip
      
      foreach curn, wcard
      {
         if cur.name.fwildcard( curn ) 
         {
            skip = 1
            break
         } 
      }
      if skip : continue
      // Save subfolders
      destname = dest
      if cpyflag & $CMD_RELPATH  
      {
         temp.copy( cur.fullname.ptr() + *srcdir + 1 )
         destname.faddname( temp )
      }
      else : destname.faddname( cur.name ) 
      
      if cur.attrib & $FILE_ATTRIBUTE_DIRECTORY : temp = destname
      else : temp.fgetdir( destname )
      
      label dirretry      
      if !verifypath( temp, 0->arrstr ) && cpyflag & $CMD_ERRMSG 
      {
         ret = "msgdelret"
         
         message( $MSG_HAND, "#@errcreate# \(temp)!", 
                  %{ "retry", "ignore" }, ret )
                  
         if ret %== "retry" : goto dirretry
         elif ret %== "ignore" : return 0  
      }     
      label again
      if cur.attrib & $FILE_ATTRIBUTE_DIRECTORY
      {
//         copycmd( cur.fullname + "\\*.*", ignore, delflag )
//         ok = deletedir( cur.fullname )
      }
      else
      {
         if fileexist( destname )
         {
            finfo fi
            
            if cpytype == $COPY_NEW : continue

            getfileinfo( destname, fi )
            
            if cpytype == $COPY_NEWER && 
                CompareFileTime( cur.lastwrite, fi.lastwrite ) <= 0 
            {
               continue
            }
            if cpytype == $COPY_DIF && fi.sizelo == cur.sizelo && 
               isequalfiles( cur.fullname, destname )
            {
               continue
            }
            setattribnormal( destname )
         }
         file  hsrc hdest 
         uint  size icopy
         buf   cbuf
         
         label fileretry
         
         if !hsrc.open( cur.fullname, $OP_READONLY ) && 
                      cpyflag & $CMD_ERRMSG 
         {
            if skipall : continue

            ret = "msgdelret"
            message( $MSG_HAND, "#@errcreate# \(cur.fullname)!", 
                  %{ "retry", "skip", "skipall" }, ret )
                  
            if ret %== "retry" : goto fileretry
            elif ret %== "skip" : continue 
            elif ret %== "skipall"
            {
               skipall = 1 
               continue 
            }
         }
         
         if !hdest.open( destname, $OP_CREATE ) && cpyflag & $CMD_ERRMSG
         {
            hsrc.close( )
            if skipall : continue
            
            ret = "msgdelret"
            message( $MSG_HAND, "#@errcreate# \(destname)!", 
                  %{ "retry", "skip", "skipall" }, ret )
            
            if ret %== "retry" : goto fileretry
            elif ret %== "skip" : continue 
            elif ret %== "skipall"
            {
               skipall = 1 
               continue 
            }
         }
         size = cur.sizelo
         
         uint copied = 0
         while size
         {
            icopy = min( size, 0x80000 )//300000 )
            cbuf.use = 0
            hsrc.read( cbuf, icopy )
            label writeretry
            if !hdest.write( cbuf )
            {
               ret = "msgdelret"
               message( $MSG_HAND, "#@errwrite# \(destname)!", 
                  %{ "retry", "ignore" }, ret )
               if ret %== "retry" : goto writeretry
               elif ret %== "ignore" : break 
            }
//            notify( $COPYN_PROCESS, &destname, 
//                    uint( long( copied += icopy ) * 100L / long( cur.sizelo )))
            size -= icopy
         }
         hdest.settime( cur.lastwrite )
         hdest.close( )
         hsrc.close( )
         setfileattrib( destname, cur.attrib )
         ok = 1
      }
      if ok
      {
         defmacro.set( "copyfile", destname )
         copybody->func()
         if cpyflag & $CMD_LOGOUT
         {
            outtextnew( "#@copy#: \(cur.fullname) => \(destname)" )   
         }
      }
   }
   return 1
}