/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

include
{ 
   $"..\libs\winfolders.g"
   $"..\libs\registry\registry.g"
   "..\\libs\\winversion.g"
   $"..\..\res\lib\vis.ge"
   "macros.g"
}

global 
{
//   macro  defmacro
   uint   logwait logtype
   uint   mainwnd
}

func str getlistval( str param, uint ptr )
{
   param.copy( ptr->uint )
   ptr->uint += *param + 1
   return param
}

func uint getlistptr( uint dataoff, uint ptr )
{
   uint count 
   
   if dataoff == 0xFFFFFFFF || dataoff >= *g_list : return 0
   ptr->uint = g_list.ptr() + dataoff
   count = ( ptr->uint )->uint
   ptr->uint += 4
   return count
}   

include 
{
   "..\\libs\\thread.g"
   "..\\libs\\message.g"
}

define
{
   KEY_KEYALT    =  0x1000 
   KEY_KEYCTRL   =  0x2000 
   KEY_KEYSHIFT  =  0x4000 
   KEY_KEYUP     =  0x8000
   KEY_KEYWIN    =  0x10000
   
   CMD_LOGOUT    = 0x10000
   CMD_RECURSIVE = 0x20000
   CMD_ERRMSG    = 0x40000
}

global 
{
   winver defver
   uint   waitkey
   thread waitth
   datetime  lastdt
}
 
import "user32.dll"
{
   uint GetForegroundWindow()
}
 
include 
{
   "..\\libs\\reboot.g"
}

// gentee!!!
func long makelong( uint hi low )
{
   return long( low ) + ( ulong( hi ) << 32L )
}

func loghook( uint key )
{
   if key == waitkey : waitth.terminate( 0 )   
}

func str getwintext( uint hwnd, str ret )
{  //    vEdit 
   ustr pText
   
   uint res = GetWindowTextLength( hwnd )
   pText.reserve( res + 1 )
   GetWindowText( hwnd, pText.ptr(), res + 1 )    
   pText.setlen( res )
   return ret = pText
}

func dynmacro( str key, macroitem mi )
{
   str value
   datetime dt
   
   dt.gettime()
   key.lower()
   switch key
   {
      case "activewin"
      {
         getwintext( GetForegroundWindow(), value )
      }
      case "diftime"
      {
         dt -= lastdt
         getdatetime( dt, 0->str, value )          
      }
      case "time"
      {
         lastdt.gettime()
         getdatetime( lastdt, 0->str, value )          
      }
      case "date"
      {
         getdatetime( dt, value, 0->str )          
      }
      case "shortdate"
      {
         value.printf( "%02i%02i%02i", %{ dt.year - 2000, dt.month, dt.day  })
      }
      case "shorttime"
      {
         value.printf("%02i%02i%02i", %{ dt.hour, dt.minute, dt.second })
      }
      case "curdir"
      {
         getcurdir( value )
      }
   }
   mi.value = ustr( value )
}

func script_init()
{
   uint i count
   str  stemp name
   
   defmacro.setchar('#')
   
   getlocale( defmacro, defver )
   getfolders( defmacro )
      
   defmacro.dynamic( "activewin", &dynmacro )
   defmacro.dynamic( "time", &dynmacro ) 
   defmacro.dynamic( "date", &dynmacro ) 
   defmacro.dynamic( "curdir", &dynmacro ) 
   defmacro.dynamic( "diftime", &dynmacro )
   defmacro.dynamic( "shorttime", &dynmacro ) 
   defmacro.dynamic( "shortdate", &dynmacro ) 
   
   fornum i, argc()
   {
      str val
      
      argv( val, i + 1 )
      defmacro.set( "par\(++count)", val )
   }
   defmacro.set( "parcount", count )
   
   getmodulepath( stemp, "" )
   defmacro.set( "exepath", stemp )
   getmodulename( stemp )
   stemp.fgetparts( 0->str, name, 0->str )
   defmacro.set( "exename", name )
   defmacro.set( "isexe", 1 )
   if name %== "script" && argc() > 0
   {      
      str val
      
      argv( val, 1 )
      if fileexist( val )
      { 
         stemp = val
         val.fgetdir( val )
         defmacro.set( "exepath", val )
         stemp.fgetparts( 0->str, name, 0->str )
         defmacro.set( "exename", name )
         defmacro.set( "isexe", 0 )
      }
   }
   defmacro.set( "exefile", stemp )
   defmacro.set( "autoclose", 0 )
   defmacro.set( "autoshut", 0 )

   logtype = 1//$LOG_WIN
   
   App.StyleM.AddStyle( "bold", "<style ver=1>
   <font size=+2 bold=1/></style>" ) 
}

func uint ifcondition( str param )
{
   uint ret not 
   
   if !*param : return 1
   
   if param[0] == '!'
   {
      param.del( 0, 1 )
      not = 1
   }
   if param[0] == '@'
   {
      uint idfunc
      collection clt
      
      param.del( 0, 1 )
      if idfunc = getid( param, 0, clt ) : ret = idfunc->func()      
   }
   else
   { 
      param.trim( '#', $TRIM_LEFT | $TRIM_RIGHT )
      ret = defmacro.getint( param )
   }
   if not : ret = !ret 
   return ret
}
