/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

define 
{
   DEL_FILES    = 0x0001
   DEL_READONLY = 0x0002
   DEL_RECBIN   = 0x0004

   FO_DELETE = 0x0003
   FOF_SILENT         = 0x0004  // don't create progress/report
   FOF_NOCONFIRMATION = 0x0010  // Don't prompt the user.
   FOF_ALLOWUNDO      = 0x0040
   FOF_NOERRORUI      = 0x0400  // don't put up error UI
}

type SHFILEOPSTRUCT 
{
    uint hwnd
    uint wFunc
    uint pFrom
    uint pTo
    uint fFlags
    uint fAnyOperationsAborted
    uint hNameMappings
    uint lpszProgressTitle
}

import "shell32.dll"
{
   int SHFileOperationA( SHFILEOPSTRUCT ) -> SHFileOperation
}

// gentee !!!
func uint delfile2recbin( str filename )
{
   SHFILEOPSTRUCT fileop
   buf  bfile
   
   bfile = filename
   bfile += byte( 0 )
   fileop.wFunc = $FO_DELETE;
   fileop.pFrom = bfile.ptr();
   fileop.fFlags = $FOF_ALLOWUNDO | $FOF_SILENT | $FOF_NOCONFIRMATION |
                   $FOF_NOERRORUI;
   
   return !SHFileOperation( fileop )
}

func uint delcmd( str filename ignore, uint delflag )
{
   arrstr wcard
   uint   skipall
      
   if !*filename : return 0
   defmacro.replace( filename )
   defmacro.replace( ignore )

   ffind fd
   uint  flag = $FIND_FILE
   
   if !( delflag & $DEL_FILES ) : flag |= $FIND_DIR
   if delflag & $CMD_RECURSIVE : flag |= $FIND_RECURSE

   if *ignore : ignore.split( wcard, ',', $SPLIT_NOSYS )
      
   fd.init( filename, flag )
   foreach cur, fd
   {
      uint ok skip
      
      foreach curn, wcard
      {
         if cur.name.fwildcard( curn ) 
         {
            skip = 1
            break
         } 
      }
      if skip : continue
      label again
      if cur.attrib & $FILE_ATTRIBUTE_DIRECTORY
      {
         delcmd( cur.fullname + "\\*.*", ignore, delflag )
         ok = deletedir( cur.fullname )
      }
      else
      {
         if delflag & $DEL_READONLY && ( cur.attrib & $FILE_ATTRIBUTE_READONLY )
         {
            setattribnormal( cur.fullname )
         }
         if delflag & $DEL_RECBIN : ok = delfile2recbin( cur.fullname )
         else : ok = deletefile( cur.fullname )
      }
      if ok
      {
         if delflag & $CMD_LOGOUT
         {
            outtextnew( "#@delete#: \(cur.fullname)" )   
         }
      }
      elif delflag & $CMD_ERRMSG && 
          !(cur.attrib & $FILE_ATTRIBUTE_DIRECTORY) && !skipall 
      {
         str ret = "msgdelret"
         
         message( $MSG_HAND, "#@errdel# \(cur.fullname)!", 
                  %{ "retry", "skip", "skipall" }, ret )
         
         if ret == "retry" : goto again
         elif ret == "skip" { }  
         elif ret == "skipall" : skipall = 1
      } 
   }
   return 1
}