/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

import "kernel32.dll"
{
   uint GetDiskFreeSpaceExA( uint, uint, uint, uint ) -> GetDiskFreeSpaceEx 
}

// gentee !!
func long getdiskspace( str path, uint ptotal )
{
   long result
   
   if !GetProcAddress( GetModuleHandle( "kernel32.dll".ptr() ),
                         "GetDiskFreeSpaceExA".ptr())
   {
      return 0L
   }
   GetDiskFreeSpaceEx( path.ptr(), &result, ptotal, 0 )
   
   return result   
}

func drivespace( str drive var )
{
   long total free
    
   defmacro.replace( drive )
   free = getdiskspace( drive, &total )
     
   defmacro.set( var, free )
   defmacro.set( "\(var)kb", free /= 1024L )
   defmacro.set( "\(var)mb", free /= 1024L )
   defmacro.set( "\(var)gb", free /= 1024L )
   var += "total"
   defmacro.set( var, total )
   defmacro.set( "\(var)kb", total /= 1024L )
   defmacro.set( "\(var)mb", total /= 1024L )
   defmacro.set( "\(var)gb", total /= 1024L )
}