/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

define
{
   MCI_DEVTYPE_CD_AUDIO  = 516
   
   MCI_OPEN_SHAREABLE    = 0x00000100
   MCI_OPEN_ELEMENT      = 0x00000200
   MCI_OPEN_ALIAS        = 0x00000400
   MCI_OPEN_ELEMENT_ID   = 0x00000800
   MCI_OPEN_TYPE_ID      = 0x00001000
   MCI_OPEN_TYPE         = 0x00002000

   MCI_STATUS_READY      = 0x00000007
   MCI_SET_DOOR_OPEN     = 0x00000100
   MCI_SET_DOOR_CLOSED   = 0x00000200
   
   MCI_OPEN              = 0x0803
   MCI_CLOSE             = 0x0804
   MCI_SET               = 0x080D
   MCI_WAIT              = 0x00000002
} 

// gentee!!!

type MCI_OPEN_PARMS {
    uint         dwCallback 
    uint         wDeviceID   // MCIDEVICEID 
    uint         lpstrDeviceType 
    uint         lpstrElementName 
    uint         lpstrAlias
} 

type MCI_STATUS_PARMS {
    uint  dwCallback 
    uint  dwReturn 
    uint  dwItem 
    uint  dwTrack 
} 

import "winmm.dll"
{
   uint mciSendCommandA( uint, uint, uint, uint ) -> mciSendCommand 
}

func eject( str letter, uint open )
{
   MCI_OPEN_PARMS   op
   MCI_STATUS_PARMS st
   uint             flags
   arrstr           drives

   defmacro.replace( letter )
   op.lpstrDeviceType = $MCI_DEVTYPE_CD_AUDIO
   
   if !*letter || letter == "*"
   {
      arrstr alldrives
      
      alldrives = getdrives()
      foreach curd, alldrives
      {
         if getdrivetype( "\(curd)\\" ) == $DRIVE_CDROM
         {
            drives += curd
            if !*letter : break
         }
      }
   }
   else 
   {
      drives += "X:" 
      drives[0][0] = letter[0]
   }
   foreach curdrive, drives
   {
      op.lpstrElementName = curdrive.ptr()
      flags = $MCI_OPEN_TYPE | $MCI_OPEN_TYPE_ID | $MCI_OPEN_ELEMENT |
              $MCI_OPEN_SHAREABLE
// flags = MCI_OPEN_TYPE | MCI_OPEN_TYPE_ID | MCI_OPEN_SHAREABLE 

      if !mciSendCommand( 0, $MCI_OPEN, flags, &op )
      {
         st.dwItem = $MCI_STATUS_READY

         if open : mciSendCommand( op.wDeviceID,$MCI_SET,$MCI_SET_DOOR_OPEN,0 )
         else : mciSendCommand( op.wDeviceID,$MCI_SET,$MCI_SET_DOOR_CLOSED,0 )

         mciSendCommand( op.wDeviceID, $MCI_CLOSE, $MCI_WAIT, 0 )
      }
   }
}