/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

func fileinfo( str filename, str var )
{
   finfo fi
   uint  exist
   file  ff
   str   date time
   datetime dt
   
   if !*var : var = "fi"
   defmacro.replace( filename )
   exist = getfileinfo( filename, fi )
   defmacro.set( var, fi.fullname )
   defmacro.set( "\(var)exist", exist )
   defmacro.set( "\(var)size", makelong( fi.sizehi, fi.sizelo ) )
   defmacro.set( "\(var)dir", ?( fi.attrib & $FILE_ATTRIBUTE_DIRECTORY, 1 , 0 ))
   defmacro.set( "\(var)readonly", ?( fi.attrib & $FILE_ATTRIBUTE_READONLY, 
                                      1 , 0 ))
   defmacro.set( "\(var)hidden", ?( fi.attrib & $FILE_ATTRIBUTE_HIDDEN, 1 , 0 ))
   defmacro.set( "\(var)system", ?( fi.attrib & $FILE_ATTRIBUTE_SYSTEM, 1 , 0 ))
   defmacro.set( "\(var)archive",?( fi.attrib & $FILE_ATTRIBUTE_ARCHIVE, 1 , 0 ))
   defmacro.set( "\(var)used", 0 )  
   defmacro.set( "\(var)write", 0 )  
   if exist
   {
      if !ff.open( fi.fullname, $OP_EXCLUSIVE )
      {
         defmacro.set( "\(var)used", 1 )
      }
      else : ff.close()
      if ff.open( fi.fullname, 0 )
      {
         defmacro.set( "\(var)write", 1 )
         ff.close()
      }
   }
   getfiledatetime( fi.created, date, time )
   defmacro.set( "\(var)ctime", "\( date ) \( time )" )  
   getfiledatetime( fi.lastaccess, date, time )
   defmacro.set( "\(var)atime", "\( date ) \( time )" )  
   getfiledatetime( fi.lastwrite, date, time )
   defmacro.set( "\(var)wtime", "\( date ) \( time )" )
   ftimetodatetime( fi.lastwrite, dt, 1 )
   defmacro.set( "\(var)year", dt.year )  
   defmacro.set( "\(var)month", dt.month )  
   defmacro.set( "\(var)day", dt.day )  
   defmacro.set( "\(var)hour", dt.hour )  
   defmacro.set( "\(var)minute", dt.minute )  
   defmacro.set( "\(var)second", dt.second )  
   dt.tostr( date )  
   defmacro.set( "\(var)swtime", date )  
}