/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

func foldersize( str dir filename var, uint recurse )
{
   str   fname
   ffind fd
   long  summary
   uint  count
    
   if !*dir  : return
   
   defmacro.replace( ( fname = dir ).faddname( filename ))
      
   fd.init( fname, $FIND_FILE | ?( recurse, $FIND_RECURSE, 0 ))
   foreach cur, fd
   {
      summary += makelong( cur.sizehi, cur.sizelo )
      count++
   }
   defmacro.set( var, summary )
   defmacro.set( "\(var)kb", summary /= 1024L )
   defmacro.set( "\(var)mb", summary /= 1024L )
   defmacro.set( "\(var)count", count )
}