/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

include : $"..\libs\csvfile.g"

define
{
   CSVS_COMMA = ',' 
   CSVS_SEMICOL = ';'
   CSVS_COLON = ':'
   CSVS_NUMSIGN = '#'
   CSVS_VERT = '|'

   CSVL_DQUOTE = 0x22220000
   CSVL_QUOTE =  0x27270000
   CSVL_NUMSIGN = 0x23230000
   CSVL_PAREN = 0x28290000 
   CSVL_LG = 0x3C3E0000
   CSVL_SQUARE = 0x5B5D0000
   CSVL_CURLY  = 0x7B7D0000  
}

func forcsv( str var filename, uint txtfunc bodyfunc, uint sepquote )
{
   arrstr  vars
   uint    sep left right
   
   subfunc  csvline( arrstr cur )
   {
      uint k 
      fornum k, min( *cur, *vars )
      { 
         defmacro.set( vars[k], cur[k] )                 
      }
      while k < *vars : defmacro.set( vars[k++], "" )
      bodyfunc->func()
   }

   sep = sepquote & 0xFF
   left = sepquote >> 24
   right = ( sepquote >> 16 ) & 0xFF
   
   var.split( vars, ',', $SPLIT_NOSYS )
   if *filename
   {
      csvfile csvf
      defmacro.replace( filename )
   
      csvf.settings( sep, left, right )   
      csvf.open( filename )
      foreach cur, csvf : csvline( cur )
      csvf.close()
   }
   csv csvtxt
   
   csvtxt.settings( sep, left, right )   
   csvtxt@txtfunc->func()
   if *csvtxt < 32 && defmacro.ismacro( csvtxt )
   {
      csvtxt = str( defmacro[ csvtxt ])   
   }
   foreach curt, csvtxt : csvline( curt )
}