/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

func formcmd( uint dataoff, uint hide )
{
   uint   ptr i count id iscont 
   str    sgt sval stemp
   
   count = getlistptr( dataoff, &ptr )
   if !count : return
   
   fornum i, count
   {
      str ctrl ctext cvar clist cval stemp cwidth
      arrstr  items
      uint    width
      
      getlistval( ctrl, &ptr )
      getlistval( ctext, &ptr )
      defmacro.replace( ctext )
      getlistval( cvar, &ptr )
      getlistval( clist, &ptr )
      defmacro.replace( clist )
      getlistval( cwidth, &ptr )
      
      ustr( stemp = ctext ).toutf8( ctext )
   
      width = uint( cwidth ) 
      if *cwidth && width : cwidth = " width=\( width )"
      else : cwidth.clear()
                     
      if *clist 
      {
         clist.split( items, ',', $SPLIT_NOSYS )
      }
      if ctrl == "text"
      {
         sgt += "<id\(++id) req=0 ctrl=text>
                \(ctext)</>"         
         sval += "<id\(id)></>"         
      }
      if !*cvar : continue
      defmacro.get( cvar, cval )   
      ustr( stemp = cval ).toutf8( cval )               
      if ctrl == "checkbox"
      {
         sgt += "<id\(++id) label=\"\(ctext)\" req=0 ctrl=checkbox></>"         
         sval += "<id\(id) var = \( cvar )>\( defmacro.getint( cvar ))</>"         
      }
      elif ctrl == "edit"
      {
         sgt += "<id\(++id) label=\"\(ctext)\" req=0 ctrl=edit \( cwidth )></>"
         sval += "<id\(id) var = \( cvar )>\( cval )</>"         
      }
      elif ctrl == "file"
      {
         sgt += "<id\(++id) label=\"\(ctext)\" req=0 ctrl=selfile labpos = above></>"
         sval += "<id\(id) var = \( cvar )>\( cval )</>"         
      }
      elif ctrl == "folder"
      {
         sgt += "<id\(++id) label=\"\(ctext)\" req=0 ctrl=selfolder labpos = above></>"
         sval += "<id\(id) var = \( cvar )>\( cval )</>"         
      }
      elif ctrl == "combobox"
      {
         sgt += "<id\(++id) label=\"\(ctext)\" req=0 ctrl=combobox 
                 \( cwidth )><items>"
         if *items 
         {
            uint k
            fornum k,*items
            {
               str slabel
               
               defmacro.get(items[k], slabel )
               if !*slabel : slabel = items[k]
               ustr( stemp = slabel ).toutf8( slabel )  
               sgt += "<\(items[k]) label = \"\(slabel)\"></>"
            }
         }
         else : sgt += "<empty label = \"  \"></>"      
         sgt += "</></>"
         sval += "<id\(id) var = \( cvar )>\( cval )</>"         
      }
      elif ctrl == "buttons" && *items
      {
         sgt += "<id\(++id) label=\"\" req=0 ctrl=buttons itemwidth = \( ?(
               width, width, 120 )) labpos = center><items>"

         uint k 
         fornum k,*items
         {
            str slabel
            uint width
              
            defmacro.get(items[k], slabel )
            if !*slabel : slabel = items[k]
            if items[k] == "continue" : iscont = 1 
            ustr( stemp = slabel ).toutf8( slabel )
            width = uint( defmacro.getint("\( items[k] )_xwidth"))  
            sgt += "<\( items[k] ) label = \"\(slabel)\" \(?( width, 
                         "width=\(width)","" ))></>"
         }
         if i == count - 1 && !iscont
         {
            iscont = 1
            sgt += "<continue label = continue></>"  
         }
//         else : sgt += "<empty label = \"  \"></>"      
         sgt += "</></>"
         sval += "<id\(id) var = \( cvar ) btn = 1>\( cval )</>"
      }          
//      sgt += "\l"
   }
   if !iscont
   {
      sgt += "<btns label=ctrlitem ctrl=buttons labpos=center itemwidth = 150 >
       <items >
         <continue label = continue></>  
         </>
      </>"
   }
   stemp = "<msg>
<fields>
   \( sgt )
</fields>
</msg>
<msgval>
   \(sval)
</>
"
   defmacro.set( "gtmsg", stemp )
   defmacro.set( "retmsg", "btnret" )
   
   if hide : SendMessage( LogForm.hwnd, $WM_COMMAND, $CMD_SHOWHIDE, 0 )
//   if hide : LogForm.LogList.Visible = 0
   
   logwait = 1
   SendMessage( mainwnd, $WM_COMMAND, $MESSAGE, 0 )
   waitform( "btnret" )
//   while logwait : Sleep( 500 )
   SendMessage( LogForm.hwnd, $WM_COMMAND, $CMD_BUTTONS, 0 )
/*   uint vars
   vars as LogForm.gtforcard.find( "msgval" )
   foreach curv,vars
   {
      str varname
      curv.get( "var", varname )
      if *varname
      {
         ustr us 
         defmacro[ varname ] = us.fromutf8( curv.value )
         
         if curv.find( "btn" )
         {
            defmacro.set( varname, defmacro.get( "btnret", "" ))      
         } 
      }
   }*/
   if hide : SendMessage( LogForm.hwnd, $WM_COMMAND, $CMD_SHOWHIDE, 1 )
//   if hide : LogForm.LogList.Visible = 1
}