/******************************************************************************
*
* Copyright (C) 2009, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

include : $"..\libs\ftp\ftp.g"

define
{
   FTP_FILELOWER = 0x10    
   FTP_FILEUPPER = 0x20
   FTP_DELDIR    = 0x40
}

global
{
   str  ftpresult = "ftpresult"
   ftp  ftpi
   uint isftp
}

func uint ftp_notify( uint code, inetnotify ni )
{
   switch code
   {
      case $NFYINET_ERROR
      {
//         print("\(code) \(inet_error())\n") 
      }
   }
   return 1
}

func ftpclose( uint flag )
{
   defmacro.set( ftpresult, ftpi.close())
   if isftp && flag & $CMD_LOGOUT 
   {
      outtext( "FTP: #@disconnect#")  
   }
   isftp = 0
   inet_close()
}

func ftpopen( str host user pass varname, uint flag )
{
   if *varname : ftpresult = varname
   if isftp : ftpclose( 0 )  
   
   inet_init()
   defmacro.replace( host )
   defmacro.replace( user )
   defmacro.replace( pass )
   label again
   if isftp = ftpi.open( host, user, pass, flag & 0xFF, &ftp_notify )
   {
      if flag & $CMD_LOGOUT 
      {
         outtext( "FTP \(host): #@connect#")  
      }
   }
   elif flag & $CMD_ERRMSG 
   {
      str ret = "msgret"
      message( $MSG_HAND, "#@error# \(inet_error())! FTP #@connect#: \(host)", 
                     %{ "retry", "ignore" }, ret )
      if ret %== "retry" : goto again
//         elif ret %== "ignore" : return 0  
   } 
   defmacro.set( ftpresult, isftp )
}

func ftpgetdir( str varname, uint flag )
{
   uint ret
   str  dir
   
   if isftp
   {
      label again
      ret = ftpi.getcurdir( dir )
      if !ret && flag & $CMD_ERRMSG 
      {
         str ret = "msgret"
         message( $MSG_HAND, "#@error# \(inet_error())! FTP #@getdir#", 
                     %{ "retry", "ignore" }, ret )
         if ret %== "retry" : goto again
      } 
   }
   defmacro.set( varname, dir )
   defmacro.set( ftpresult, ret )
}

func ftpsetdir( str dirname, uint flag )
{
   uint ret
   str  dir
   
   if isftp
   {
      label again
      defmacro.replace( dirname )
      ret = ftpi.setcurdir( dirname )
      if !ret && flag & $CMD_ERRMSG 
      {
         str ret = "msgret"
         message( $MSG_HAND, "#@error# \(inet_error())! FTP #@setdir#: \( dirname )", 
                     %{ "retry", "ignore" }, ret )
         if ret %== "retry" : goto again
      } 
   }
   defmacro.set( ftpresult, ret )
}

func ftpcreatedir( str dirname, uint flag )
{
   uint ret
   str  dir
   
   if isftp
   {
      label again
      defmacro.replace( dirname )
      ret = ftpi.createdir( dirname )
      if !ret && flag & $CMD_ERRMSG 
      {
         str ret = "msgret"
         message( $MSG_HAND, "#@error# \(inet_error())! FTP #@createdir#: \( 
                  dirname )", %{ "retry", "ignore" }, ret )
         if ret %== "retry" : goto again
      } 
   }
   defmacro.set( ftpresult, ret )
}

func ftpupload( str filename dirname, uint flag )
{
   uint ret
   str  dir dest fname
   
   if isftp
   {
      label again
      defmacro.replace( dirname )
      defmacro.replace( filename )
      fname.fnameext( filename )
         
      dest = dirname
      if !dest.islast( '/' ) : dest += "/"
      if flag & $FTP_FILELOWER : fname.lower() 
      elif flag & $FTP_FILEUPPER : fname.upper() 
      dest += fname
      if flag & $CMD_LOGOUT 
      {
         outtext( "#@uploadfile# \(filename) => \(dest) ..." )  
      }
      ret = ftpi.putfile( filename, dest, $FTP_BINARY )
      if flag & $CMD_LOGOUT 
      {
         outtext( "#@uploadfile# \(filename) => \(dest) OK", 0 )  
      }
      if !ret && flag & $CMD_ERRMSG 
      {
         str ret = "msgret"
         message( $MSG_HAND, "#@error# \(inet_error())! FTP #@uploadfile#: \( 
                  filename )", %{ "retry", "ignore" }, ret )
         if ret %== "retry" : goto again
      } 
   }
   defmacro.set( ftpresult, ret )
}

func ftpdownload( str filename dirname, uint flag )
{
   uint ret
   str  dir dest fname stemp
   
   if isftp
   {
      label again
      defmacro.replace( dirname )
      defmacro.replace( filename )
      
      stemp.replacech( filename, '/', "\\")   
      fname.fnameext( stemp )
         
      ( dest = dirname ).faddname( fname )
      if flag & $CMD_LOGOUT 
      {
         outtext( "#@download# \(filename) => \(dest) ..." )  
      }
      ret = ftpi.getfile( filename, dest, $FTP_BINARY )
      if flag & $CMD_LOGOUT 
      {
         outtext( "#@download# \(filename) => \(dest) OK", 0 )  
      }
      if !ret && flag & $CMD_ERRMSG 
      {
         str ret = "msgret"
         message( $MSG_HAND, "#@error# \(inet_error())! FTP #@download#: \( 
                  filename )", %{ "retry", "ignore" }, ret )
         if ret %== "retry" : goto again
      } 
   }
   defmacro.set( ftpresult, ret )
}

func ftpdelete( str filename, uint flag )
{
   uint ret
  
   if isftp
   {
      label again
      defmacro.replace( filename )
      
      ret = ?( flag & $FTP_DELDIR, ftpi.deldir( filename ),
               ftpi.delfile( filename ))
      if ret && flag & $CMD_LOGOUT 
      {
         outtext( "FTP #@delete#: \(filename) OK", 0 )  
      }
      if !ret && flag & $CMD_ERRMSG 
      {
         str ret = "msgret"
         message( $MSG_HAND, "#@error# \(inet_error())! FTP #@delete#: \( 
                  filename )", %{ "retry", "ignore" }, ret )
         if ret %== "retry" : goto again
      } 
   }
   defmacro.set( ftpresult, ret )
}

func ftprename( str filename newname, uint flag )
{
   uint ret
  
   if isftp
   {
      label again
      defmacro.replace( filename )
      defmacro.replace( newname )
      
      ret = ftpi.rename( filename, newname )
      if ret && flag & $CMD_LOGOUT 
      {
         outtext( "FTP #@renmove#: \(filename) => \( newname ) OK", 0 )  
      }
      if !ret && flag & $CMD_ERRMSG 
      {
         str ret = "msgret"
         message( $MSG_HAND, "#@error# \(inet_error())! FTP #@rename#: \( 
                  filename )", %{ "retry", "ignore" }, ret )
         if ret %== "retry" : goto again
      } 
   }
   defmacro.set( ftpresult, ret )
}