/******************************************************************************
*
* Copyright (C) 2008-2009, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

include : "..\\libs\\winproc.g"
include : "service.g"

func uint isapptrue( uint dataoff )
{
   uint ptr i count ret
   str  next
   
   count = getlistptr( dataoff, &ptr )
   if !count : return 0
   fornum i, count
   {
      str exename iftype not
      uint cmp
     
      getlistval( exename, &ptr )
      defmacro.replace( exename ) 
      getlistval( iftype, &ptr )
      getlistval( not, &ptr )
      switch iftype
      {
         case "process"
         {
            uint  snap
            PROCESSENTRY32  pentry
            str   name
            
            name.fnameext( exename )
            snap = CreateToolhelp32Snapshot( $TH32CS_SNAPPROCESS, 0 )
            if snap != 0xFFFFFFFF 
            {
               pentry.dwSize = sizeof( PROCESSENTRY32 )
            
               if Process32First( snap, pentry )
               {  
                  do
                  {  
                     str exefile
                     exefile.copy( &pentry.szExeFile )
                     if name %== exefile
                     {
                        cmp = 1
                        break
                     }
                  } while Process32Next( snap, pentry ) 
               }
               CloseHandle( snap )
            }
         }
         case "service"
         {
            cmp = isservice( exename )
         }
         case "servrun"
         {
            cmp = isservicerun( exename )
         } 
      }      
      if uint( not ) : cmp = !cmp
      if next == "and" : ret &= cmp
      elif next == "or" : ret |= cmp
      else : ret = cmp
      getlistval( next, &ptr )
   }
   return ret
}