/******************************************************************************
*
* Copyright (C) 2008-2009, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

import "kernel32.dll"
{
   uint GetVolumeInformationA(
      uint, uint, uint, uint, uint, uint, uint, uint ) -> GetVolumeInformation
}

// gentee !!!

func int cmpfiletime( str left right )
{
   finfo fileft firight
            
   getfileinfo( left, fileft )
   getfileinfo( right, firight )
            
   return CompareFileTime( fileft.lastwrite, firight.lastwrite )
}

func uint isfiletrue( uint dataoff )
{
   uint ret count ptr i 
   str  next
   
   subfunc getval( str param )
   {
      param.copy( ptr )
      ptr += *param + 1
   }
   if dataoff >= *g_list : return 0
   ptr = g_list.ptr() + dataoff
   count = ptr->uint
//   print("Count=\(count)\n")
   if !count : return 0
   ptr += 4
   fornum i, count
   {
      str filename iftype not param
      uint cmp
      
      getval( filename )
      defmacro.replace( filename )
      getval( iftype )
      getval( not )
      getval( param )
      defmacro.replace( param )

      switch iftype
      {
         case "existfile" : cmp = fileexist( filename ) 
         case "existdir" : cmp = direxist( filename ) 
         case "cddvd"
         {
            str drive
            uint serial
            
            drive.fgetdrive( filename )
            if getdrivetype( drive ) != $DRIVE_CDROM
            {
               arrstr drives
               drives = getdrives()
               foreach curd, drives
               {
                  if getdrivetype( curd ) == $DRIVE_CDROM
                  {
                     drive = curd
                     break
                  }            
               }
            }
            cmp = GetVolumeInformation( drive.ptr(), 0, 0, &serial, 0, 0, 
                                        0, 0 ) && serial
         }
         case "newer"
         {
            if param[0] == '*'
            {
               datetime dt
               filetime ft
               finfo fi
               
               param.del( 0, 1 )
               dt.fromstr( param )
               datetimetoftime( dt, ft )
               getfileinfo( filename, fi )
               cmp = ( CompareFileTime( fi.lastwrite, ft ) > 0 )                       
            }
            else : cmp = ( cmpfiletime( filename, param ) > 0 )
         }         
         case "substr"
         {
            buf      in
            spattern sp
            in.read( filename )
            sp.init( param, 0 )
            cmp = ( sp.search( in, 0 ) < *in ) 
         } 
         case "wild"
         {
            arrstr  wilds
            str     fname
            
            fname.fnameext( filename )            
            param.split( wilds, ',', $SPLIT_NOSYS )
            foreach curw,wilds
            {
               if fname.fwildcard( curw ) 
               {
                  cmp = 1
                  break
               } 
            }
         }
      }
      if uint( not ) : cmp = !cmp
      if next == "and" : ret &= cmp
      elif next == "or" : ret |= cmp
      else : ret = cmp
      getval( next )      
   }   
   return ret
}