/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

func uint istrue( uint dataoff )
{
   uint ret count ptr i 
   str  next
   
   subfunc getval( str param )
   {
      param.copy( ptr )
      ptr += *param + 1
   }
   if dataoff >= *g_list : return 0
   ptr = g_list.ptr() + dataoff
   count = ptr->uint
//   print("Count=\(count)\n")
   if !count : return 0
   ptr += 4
   fornum i, count
   {
      str varname iftype right left
      uint cmp
      
      getval( varname )
      defmacro.get( varname, left )
      getval( iftype )
      getval( right )
      defmacro.replace( right )
//      print("\( varname ) \(left) \(iftype) \(right)\n")
      switch iftype
      {
         case "equal" : cmp = ( left == right ) 
         case "equali" : cmp = ( left %== right ) 
         case "noteq" : cmp = ( left != right ) 
         case "noteqi" : cmp = ( left %!= right ) 
         case "empty" : cmp = ?( *left && left != "0", 0, 1 ) 
         case "notempty" : cmp = ?( *left && left != "0", 1, 0 ) 
         case "check" : cmp = ?( uint( left ), 1, 0 ) 
         case "uncheck" : cmp = ?( uint( left ), 0, 1 ) 
         case "substr" : cmp = left.search( right, $QS_IGNCASE )
      }
      if next == "and" : ret &= cmp
      elif next == "or" : ret |= cmp
      else : ret = cmp
      getval( next )      
   }   
   return ret
}