/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

include : $"..\libs\keyboard.g"

func keystroke( str ktype, str out )
{
   arrstr items
   
   defmacro.replace( out )
   Sleep( 200 )
   if ktype == "text"
   {
      sendstr( out ) 
   }
   else
   {
      items.loadtrim( out )
      foreach cur, items
      {
         arrstr val
         uint vkey flag
         
         cur.split( val, '+', $SPLIT_NOSYS | $SPLIT_EMPTY )
         if *val == 1
         {
            val.clear()
            cur.split( val, '-', $SPLIT_NOSYS | $SPLIT_EMPTY )
         }
         foreach curkey, val
         {
            if *curkey == 1 
            {
               vkey = VkKeyScan( curkey[0] ) & 0xFF
               continue
            }      
            switch curkey
            {
               case "Alt" : flag |= $SVK_ALT
               case "Back" : vkey = $VK_BACK
               case "Ctrl" : flag |= $SVK_CONTROL
               case "Delete" : vkey = $VK_DELETE
               case "Down" : vkey = $VK_DOWN
               case "End" : vkey = $VK_END
               case "Enter" : vkey = $VK_RETURN
               case "Esc" : vkey = $VK_ESCAPE
               case "Home" : vkey = $VK_HOME
               case "Insert" : vkey = $VK_INSERT
               case "Left" : vkey = $VK_LEFT
               case "PageUp" : vkey = $VK_PRIOR
               case "PageDown" : vkey = $VK_NEXT
               case "Right" : vkey = $VK_RIGHT
               case "Shift" : flag |= $SVK_SHIFT
               case "Space" : vkey = $VK_SPACE
               case "Tab" : vkey = $VK_TAB
               case "Up" : vkey = $VK_UP
               default
               {
                  if curkey[0] == 'F' || curkey[0] == 'f' 
                  {
                     uint i
                     fornum i =1, 13
                     { 
                        if curkey %== "F\(i)"
                        {
                           vkey |= 0x70 + ( i - 1 )
                           break
                        }
                     }
                  }
               }   
            }
         }  
         sendvkey( vkey, flag )
         Sleep( 100 )      
      }
   }
}
