/*	
 //!GFG  //!\GFG  are commentary attributes generated by 
 the Gentee form editor. You should neither delete them 
 nor make any changes into the source code from the beginning 
 of the commentary attribute //!GFG to its end //!\GFG
*/
/*
//!GFG include
include {
	"app.g"
	"dialogs.g"
	"listview.g"
	"splitter.g"
	"btn.g"
	"scrollbox.g"
	"panel.g"
	"btnpic.g"
//!\GFG

}
*/

import "kernel32"
{
   uint GetCommandLineA() -> GetCommandLine
}

//!GFG form
type vLogForm <inherit=vForm> {
	vSplitter	spMain
	vSplitter	LogSplit
	vListView	LogList
	vScrollBox	LogScroll
	vPanel	plBottom
	vBtnPic	Close
	vPanel	pLine
	vBtnPic	bRestart
	vCheckBox	chAutoclose
	vCheckBox	chAutoshut
	vOpenSaveDialog	OpenSaveDialog0
	vBtnPic	bInfo
	vSelectDir	SelectDir
	vOpenSaveDialog	OpenSaveFile
 //!\GFG
   vGtCard     gtcard
   gt          gtforcard
   uint        noconfirm
}

global
{
   uint    logcount
   vLogForm LogForm
}

//!GFG method loghook evparEvent
method uint vLogForm.loghook <alias=LogForm_loghook>( winmsg msg )//!\GFG
{
//   if msg.wpar == $WM_USER && msg.lpar == waitkey
   if msg.wpar == 0x2000 && msg.lpar == waitkey
   {
      waitth.terminate( 0 )
   }
   elif msg.wpar == $AUTOBTN 
   { 
      uint cura
      cura as msg.lpar->autoinf

      if cura.time : cura.ctrl->vBtn.Caption = ustr( "\(cura.caption) [ \(cura.time) ]" )
      else : cura.ctrl->vBtn.Caption = ustr( cura.caption )
      if cura.run
      {
         cura.run = 0
         cura.ctrl->vBtn.OnClick.Run( cura.ctrl->vCtrl )
      }   
   }
   elif msg.wpar == $CMD_OUTNEW || msg.wpar == $CMD_OUT 
   { 
   	uint ind
   
   	ind = logcount
      if msg.wpar == $CMD_OUTNEW : .LogList.Rows.Append()
      elif msg.wpar == $CMD_OUT : ind--
      .LogList.Cells( ind, 0 ).Label = ustr( msg.lpar->str )
      .LogList.Selected = LogForm.LogList.Rows[ ind ]
      if msg.wpar == $CMD_OUTNEW : logcount++
   }
   elif msg.wpar == $MESSAGE
   {
      str temp
      uint height pressok

      pressed = 2
      defmacro.get( "gtmsg", temp )
      .gtforcard.clear()
      .gtforcard += temp      
      height = .gtcard.LoadFields( .LogScroll, .gtforcard.find( "msg" ), 
                           .gtforcard.find( "msgval" ), 0 ) + 28
      .gtcard.Split( .LogScroll, .LogScroll.Width/2 )
      .LogScroll.Visible = 1
      if .LogSplit.Height > height
      {
         .LogSplit.Distance = .LogSplit.Height - height
      }   
      else : .LogSplit.Distance = 100
      foreach curbtn, autobtn.keys
      {
         autobtn[ curbtn ].ctrl = 0
         if autobtn[ curbtn ].wait 
         {
            uint ctrl = &.LogScroll.FindGtCtrl( curbtn )
            
            if ctrl
            { 
               uint  an
               an as autobtn[ curbtn ]
               an.ctrl = ctrl
               defmacro.get( curbtn, an.caption )
               if !*an.caption
               { 
                  ustr utemp
                  App.Lng.getlang( curbtn, utemp )
                  an.caption = ?( *utemp, str( utemp ), curbtn )
               } 
//               print( "\( curbtn) =\(an.caption) \(defmacro.get( "continue", "" ))\n" )
               pressok = 1
            }
         }
      }
      if pressok : pressed = 0 
   }
   elif msg.wpar == $MESSAGEOK 
   {
      .Close.SetFocus()
      .gtcard.Clear( .LogScroll )
      .LogScroll.Visible = 0
      logwait = 0
   }
   elif msg.wpar == $CMD_BUTTONS 
   {
      uint vars
      vars as LogForm.gtforcard.find( "msgval" )

      foreach curv,vars
      {
         str varname

         curv.get( "var", varname )
         if *varname
         {
            ustr us 
            defmacro[ varname ] = us.fromutf8( curv.value )
            
            if curv.find( "btn" )
            {
               defmacro.set( varname, defmacro.get( "btnret", "" ))      
            } 
         }
      }
   }
   elif msg.wpar == $CMD_TASKSTATE 
   {
      uint tsi

      tsi as msg.lpar->taskstateinfo
      if *tsi.caption : LogForm.Caption  = tsi.caption 
      if tsi.left : LogForm.Left  = tsi.left
      if tsi.top : LogForm.Top  = tsi.top
      if tsi.width : LogForm.Width  = tsi.width
      if tsi.height : LogForm.Height  = tsi.height
      if tsi.state != 0xffff : ShowWindow( mainwnd, tsi.state )
   }
   elif msg.wpar == $CMD_AUTOCLOSE 
   {
      g_thread.wait()
      this.Close()      
   }
   elif msg.wpar == $CMD_SHOWHIDE : .LogList.Visible = msg.lpar
   else : return this->vForm.wmcommand( msg )////.oldproc->func( &this, msg )
   return 0
}

method uint vLogForm.CardBtnClick <alias=vLogForm_CardBtnClick>( evparValUint evu )
{    
   uint btnitem as evu.val->gtitem
   str  btn sfunc stemp

   .Close.SetFocus()
   pressed = 1
   defmacro.get( "retmsg", btn )
   defmacro.set( btn, btnitem.name )
   sfunc = "\(btnitem.name)_xfunc"
   if defmacro.ismacro( sfunc )
   {
      uint idfunc
      collection cl
      defmacro.get( sfunc, stemp )
      idfunc = getid( "\(stemp)_used", 0, cl )

      if idfunc : idfunc->func()
   }
   else 
   {
      .gtcard.Clear( .LogScroll )
      .LogScroll.Visible = 0      
      logwait = 0
   }
   return 0
}

method  uint vLogForm.logclose()
{
   uint ret = 1

   if g_thread.isactive()
   {
      g_thread.suspend()
      if .MsgBox( "prjname".ustr(), "qstop".ustr(), 0x24 
          /* $MB_YESNO | $MB_ICONQUESTION */ ) == 6 //$IDYES
      {
         g_thread.terminate( 0 )
      }
      else : ret = 0
      g_thread.resume()
   }
   return ret
}

//!GFG method logclose evparQuery
method uint vLogForm.logclose <alias=LogForm_logclose>( evparQuery evn )//!\GFG
{
   if LogForm.chAutoshut.Visible && LogForm.chAutoshut.Checked
   {
      g_autoshut = 1
   } 
   if !.noconfirm && !.logclose() : evn.flgCancel = 1
   return 0
}

//!GFG method logbreak evparEvent
method uint vLogForm.logbreak <alias=LogForm_logbreak>( evparEvent evn )//!\GFG
{
   if .logclose()
   {
      .noconfirm = 1 
      .Close()
   } 
   return 0
}

//!GFG method loginit evparEvent
method uint vLogForm.loginit <alias=LogForm_loginit>( evparEvent evn )//!\GFG
{
   uint col
   mainwnd = this.hwnd
   col as .LogList.Columns.Append()
   col.Width = 1024
   col.Alias = ustr("outtext")

   .LogScroll.Visible = 0 
   .gtcard.Owner = this
   .gtcard.OnBtnClick.Set( this, vLogForm_CardBtnClick )
//   .Close.OnClick.Set( this, LogForm_logbreak )

   this.pTypeDef->tTypeDef.setproc( $WM_COMMAND, LogForm_loghook )
//   this.pTypeDef->tTypeDef.setproc( 0x5000, LogForm_loghook )
//   SendMessage( this.hwnd, 0x5000, 0, 0 )
   g_thread.create( g_threadfunc, 0 )
   return 0
}

//!GFG method onrestart evparEvent
method uint vLogForm.onrestart <alias=LogForm_onrestart>( evparEvent evn )//!\GFG
{
   str stemp
   
   .Close()
//   getmodulename( stemp )
//   process( stemp, 0->str, 0 )
   stemp.copy( GetCommandLine())
   process( stemp, 0->str, 0 )
   return 0
}

//!GFG method oninfo evparEvent
method uint vLogForm.oninfo <alias=LogForm_oninfo>( evparEvent evn )//!\GFG
{
   ifdef $ISABOUT
   {
      fAbout.ShowModal( this )   
   }
   return 0
}

//!GFG method Autoclose evparEvent
method uint vLogForm.Autoclose <alias=LogForm_Autoclose>( evparEvent evn )//!\GFG
{
   defmacro.set( "autoclose", LogForm.chAutoclose.Checked )
return 0
}

//!GFG method Autoshut evparEvent
method uint vLogForm.Autoshut <alias=LogForm_Autoshut>( evparEvent evn )//!\GFG
{
   defmacro.set( "autoshut", LogForm.chAutoshut.Checked )
return 0
}

//!GFG includeinit
include { $"logwin.gi" 
}//!\GFG

