/******************************************************************************
*
* Copyright (C) 2009, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

import "advapi32.dll"
{
   uint GetUserNameA( uint, uint ) -> GetUserName
}

import "mpr.dll"
{
   uint WNetGetUserA( uint, uint, uint ) -> WNetGetUser
}

import "kernel32.dll"
{
   uint GetComputerNameA( uint, uint ) -> GetComputerName
}

func getlocale( macro dmacro, winver dver )
{
   uint   i 
   str    stemp
   arrstr win = %{ "Unknown", "Windows 95", "Windows 98", "Windows ME", 
                   "Windows NT", "Windows 2000", "Windows XP",
                   "Windows 2003", "Windows Vista"}

   subfunc reg2macro( uint root, str subkey value defval smacro )
   {
      str stemp
      
      stemp.regget( root, subkey, value, defval ) 
      dmacro.set( smacro, stemp )
   }
   // LOCALE_SENGLANGUAGE 0x00001001 // English name of language
   
   str  ret 
   ret.reserve( 24 )
   stemp.reserve( 512 ) 
   GetLocaleInfo( localeuser(), 0x00001001, ret.ptr(), 24 ) 
   ret.setlenptr() 
   dmacro.set( "userlang", ret )
   // LOCALE_SABBREVCTRYNAME 0x00000007 // abbreviated country name
   // LOCALE_SENGCOUNTRY     0x00001002
   GetLocaleInfo( localeuser(), 0x00001002, ret.ptr(), 24 ) 
   ret.setlenptr() 
   dmacro.set( "usercountry", ret )

//   reg2macro( $HKEY_LOCAL_MACHINE, $"Software\Microsoft\Windows NT\CurrentVersion", 
//              "RegisteredOwner", "", "username" )
   i = 512
   if GetUserName( stemp.ptr(), &i ) : stemp.setlen( i - 1 )
   else : stemp.clear()
   dmacro.set( "username", stemp )

   i = 512
   if !WNetGetUser( 0, stemp.ptr(), &i ) : stemp.setlenptr()
   else : stemp.clear()
   dmacro.set( "userlogon", stemp ) 

   i = 512
   if GetComputerName( stemp.ptr(), &i ) : stemp.setlenptr()
   else : stemp.clear()
   dmacro.set( "computername", stemp ) 
      
   reg2macro( $HKEY_LOCAL_MACHINE, $"Software\Microsoft\Windows NT\CurrentVersion", 
              "RegisteredOrganization", "", "userorg" )
//   reg2macro( $HKEY_CURRENT_USER, 
//      $"Software\Microsoft\Windows\CurrentVersion\Explorer", "Logon User Name", 
//             "", "userlogon" )
             
   dmacro.set( "nl", "\l")
   dmacro.set( "quote", "\"")
   dmacro.set( "space", " ")
   
   winversion( dver )
   dmacro.set( "osplatform", dver.platform )
   dmacro.set( "osbuild", dver.build )     
   dmacro.set( "osmajor", dver.major )
   dmacro.set( "osminor", dver.minor )     
   dmacro.set( "oswindows", win[ ?( dver.windows < *win, dver.windows, 0 )] )
   dmacro.set( "oscsd", dver.csd )
             
}

func getfolders( macro dmacro )
{
   str  stemp sname
   uint i
   collection cl = %{ "winpath", $WINFLD_WIN,
      "syspath", $WINFLD_SYS,
      "temppath", $WINFLD_TEMP,
      "appdata", $WINFLD_APPDATA,
      "quicklaunch", $WINFLD_QLAUNCH,          
      "sendto", $WINFLD_SENDTO,
      "comappdata", $WINFLD_COMAPPDATA,
      "desktop", $WINFLD_DESKTOP,
      "comdesktop", $WINFLD_COMDESKTOP,
      "progfiles", $WINFLD_PROGFILES,
      "comprogfiles", $WINFLD_COMPROGFILES,
      "progpath", $WINFLD_PROGGROUP,
      "comprogpath", $WINFLD_COMPROGGROUP,
      "start", $WINFLD_START,
      "comstart", $WINFLD_COMSTART,
      "startup", $WINFLD_STARTUP,
      "comstartup", $WINFLD_COMSTARTUP,
      "fontpath", $WINFLD_FONT,
      "docpath", $WINFLD_DOCS,
      "comdocpath", $WINFLD_COMDOCS,
      "picpath", $WINFLD_MYPICTURES,
      "compicpath", $WINFLD_COMPICTURES,
      "musicpath", $WINFLD_MYMUSIC,
      "commusicpath", $WINFLD_COMMUSIC,
      "videopath", $WINFLD_MYVIDEO,
      "comvideopath", $WINFLD_COMVIDEO,
      "iefavpath", $WINFLD_IEFAV,
      "comiefavpath", $WINFLD_COMIEFAV,
      "cookies", $WINFLD_COOKIES,
      "history", $WINFLD_HISTORY/*,
      "drives", $WINFLD_DRIVES,
      "network", $WINFLD_NETWORK*/
   }
   
   subfunc reg2macro( uint root, str subkey value defval smacro )
   {
      str stemp
      
      stemp.regget( root, subkey, value, defval ) 
      dmacro.set( smacro, stemp )
   }
   subfunc regfld2macro( str smacro commacro prg comprg )
   {
      str  stemp
      str  shf = $"Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders"

      reg2macro( $HKEY_CURRENT_USER, shf, prg, "", smacro )
      reg2macro( $HKEY_CURRENT_USER, shf, comprg, dmacro.get( smacro, stemp ),
                  smacro )
      if *commacro
      {
         if dmacro.getint( "osplatform" ) == 1
         {
            dmacro.set( commacro, dmacro.get( smacro, stemp ))
         }
         else
         { 
            reg2macro( $HKEY_LOCAL_MACHINE, shf, comprg, 
                       dmacro.get( smacro, stemp ), commacro )
         }
      }
   }
   reg2macro( $HKEY_LOCAL_MACHINE, 
         $"Software\Microsoft\Windows\CurrentVersion", "ProgramFilesDir",
         $"C:\Program Files", "progfiles" )
           
   reg2macro( $HKEY_LOCAL_MACHINE, $"Software\Microsoft\Windows\CurrentVersion", "CommonFilesDir", $"C:\Program Files\Common Files", "comprogfiles" )
   regfld2macro( "progpath", "comprogpath", "Programs", "Common Programs" )
   regfld2macro( "desktop", "comdesktop", "Desktop", "Common Desktop" )
   regfld2macro( "startup", "comstartup", "Startup", "Common Startup" )
   regfld2macro( "startmenu", "comstartmenu", "Start Menu", "Common Start Menu" )   
   regfld2macro( "appdata", "comappdata", "AppData", "Common AppData" )
   regfld2macro( "fontpath", "", "Fonts", "Common Fonts" )
   
   dmacro.get("appdata", stemp )
   stemp.fgetdir( stemp )
   sname.fnameext( stemp )
   if sname.search("Data", $QS_IGNCASE ) : stemp.fgetdir( stemp )
   dmacro.set("userpath", stemp )

   fornum i, *cl
   {
      winfolder( cl[ i + 1 ], stemp )
      if *stemp
      {
         dmacro.set( cl[ i ]->str, stemp )
      }
      i++
   }
}
