/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

define
{
   MODT_TRIM = 0    
   MODT_UPPER   
   MODT_LOWER    
   MODT_REPLET   
   MODT_DELDUP
   MODT_GETFILE
   MODT_DELBEGIN
   MODT_DELEND
   MODT_INSBEGIN
}

func modifytext( str varname inittext, uint dataoff )
{
   uint   i ptr count 
   str    in 
   
   count = getlistptr( dataoff, &ptr )
   if !count && !*inittext : return
   
   in = ?( *inittext, inittext, str( defmacro[ varname ] )) 
   defmacro.replace( in )
   
   fornum i, count
   {
      str   stemp action out
      uint  off k 
     
      getlistval( action, &ptr )
//      action = uint( stemp )
      getlistval( stemp, &ptr )
      defmacro.replace( stemp )
      switch action
      {
         case "trim" //$MODT_TRIM 
         {
            if stemp[0] == 'L' : in.trim ( ' ', $TRIM_SYS | $TRIM_LEFT )
            elif stemp[0] == 'R' : in.trimrsys( )
            else : in.trimsys( )
         }    
         case "upper" /*$MODT_UPPER*/ : in.upper()   
         case "lower" /*$MODT_LOWER*/ : in.lower()    
         case "replace" //$MODT_REPLET 
         {
            if *stemp < 2 : break
            fornum k = 0, *in
            {
               if in[k] == stemp[0] : in[k] = stemp[1]
            }
         }   
         case "deldup" //$MODT_DELDUP
         {
            out.appendch( in[0] )
            fornum k = 1, *in
            {
               if in[k] != stemp[0] || in[ k - 1 ] != stemp[0]
               { 
                  out.appendch( in[k] )
               }
            }    
            in = out  
         }
         case "getfile" //$MODT_GETFILE
         {
            out.fnameext( in )
            in = out
         }
         case "delbegin"
         {
            in.del( 0, uint( stemp ))
         }
         case "delend"
         {
            in.setlen( *in - min( *in, uint( stemp )))
         }
         case "insbegin"
         {
            in.insert( 0, stemp )
         }
      }
   }            
   defmacro.set( varname, in )
}
      