/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

type NETRESOURCE 
{ 
   uint dwScope
   uint dwType
   uint dwDisplayType
   uint dwUsage
   uint lpLocalName
   uint lpRemoteName
   uint lpComment
   uint lpProvider
}

import "mpr.dll"
{
   uint WNetAddConnection2A( NETRESOURCE, uint, uint, 
                             uint ) -> WNetAddConnection2
   uint WNetCancelConnection2A( uint, uint, uint ) -> WNetCancelConnection2
}

define
{
   CONNECT_UPDATE_PROFILE = 0x00000001
   RESOURCETYPE_ANY       = 0x00000000

   NW_PERMANENT = 0x0001          
   NW_DEFAULT   = 0x0002
   NW_FORCE     = 0x0004
   NO_ERROR     = 0 
}

func uint mapnet( str drive netpath, uint flags, str user password )
{
   uint        ret name pass
   NETRESOURCE nr
   
   defmacro.replace( drive )
   defmacro.replace( netpath )
   defmacro.replace( user )
   defmacro.replace( password )

   drive.fdelslash()
   nr.dwType = $RESOURCETYPE_ANY
   nr.lpLocalName = drive.ptr()
   nr.lpRemoteName = netpath.ptr()
   if !( flags & $NW_DEFAULT )
   {
      name = user.ptr()
      pass = password.ptr()
   }
   label connect
   
   ret = WNetAddConnection2( nr, pass, name, 
           ?( flags & $NW_PERMANENT, $CONNECT_UPDATE_PROFILE, 0 ))
   if ret && flags & $CMD_ERRMSG
   {
      str  msgret = "msgret"
         
      message( $MSG_HAND, "#@neterr# (\(ret)): \(netpath) => \(drive)", 
                  %{ "retry", "ignore" }, msgret )
                  
      if msgret %== "retry" : goto connect
//     elif msgret %== "ignore" : return ret 
   } 
   return ret
}
      
func uint unmapnet( str drive, uint flags )
{
   uint ret
   
   defmacro.replace( drive )
   label unmap
   ret = WNetCancelConnection2( drive.ptr(), ?( flags & $NW_PERMANENT,
                  $CONNECT_UPDATE_PROFILE, 0 ), ?( flags & $NW_FORCE,
                  1, 0 ))
   if ret && flags & $CMD_ERRMSG
   {
      str  msgret = "msgret"
         
      message( $MSG_HAND, "#@neterr# (\(ret)): unmap \(drive)", 
                  %{ "retry", "ignore" }, msgret )
                  
      if msgret %== "retry" : goto unmap
//      elif msgret %== "ignore" : return ret 
   } 
   return ret
}
