/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

func parse( str var, uint igncase dataoff )
{
   uint   ptr i count
   str    src
   arrstr lines
   
   count = getlistptr( dataoff, &ptr )
   if !count : return
   
   if igncase : igncase = $QS_IGNCASE
   
   defmacro.get( var, src )
   
   fornum i, count
   {
      str prefix varname postfix result
      spattern sl sr
      uint left right i size off
     
      getlistval( prefix, &ptr )
      getlistval( varname, &ptr )
      getlistval( postfix, &ptr )
      if ( !*prefix && !*postfix ) || !*varname : continue
      defmacro.replace( prefix )
      defmacro.replace( postfix )
      if *prefix
      {
         sl.init( prefix, igncase )
         left = sl.search( src, 0 )
         if left >= *src : continue         
      }
      if *postfix
      {
         sr.init( postfix, igncase )
         right = sr.search( src, left + *prefix )
         if right >= *src || !right : continue         
      }
      if *prefix   // There is a left part 
      {
         off = left + *prefix
         if *postfix : size = right - off
         else 
         {
            fornum i = off, *src
            {
               if src[i] == 0xd || src[i] == 0xa : break 
               size++
            } 
         }                  
      }
      else
      {
         i = right - 1
         while i
         {
            if src[i] == 0xd || src[i] == 0xa : break 
            size++
            i--
         }
         off = i + 1 
      }
      result.substr( src, off, size )
      result.trimsys()
      defmacro.set( varname, result ) 
   }   
}

