/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

include : $"..\libs\socket\ping.g"

func uint pingcmd( str host timeout var, uint flag )
{
   uint time error
   
   defmacro.replace( host )
   
   inet_init()
   label again
   if time = ping( host, uint( timeout ), 20, 1, &error )
   {
      if flag & $CMD_LOGOUT
      {
         outtextnew( "#@pinghost#: \(host) => \(time) msec" )
      }
   }
   else
   {
      if flag & $CMD_ERRMSG 
      {
         str ret = "msgret"
         message( $MSG_HAND, "#@error# \(error)! #@pinghost#: \(host)", 
                     %{ "retry", "ignore" }, ret )
         if ret %== "retry" : goto again
         elif ret %== "ignore" : return 0  
      } 
   }   
   inet_close()
   if *var : defmacro.set( var, time )
   
   return 1
}