/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

func playmacrodata( buf macrodata, int speed, str srepeat )
{
   uint      repeat
   playinit  kmp

   if !*macrodata : return
   procinit( 0 )
   repeat = uint( srepeat )
   if !repeat : repeat = 1

   kmp.ptr = macrodata.ptr()
   kmp.size = *macrodata
   kmp.speed = speed
   kmp.callend = 0xFFFFFFFF
    
   while repeat--
   {
      label playretry
      if !startplay( kmp )
      {
         str ret = "msgerr"
         
         message( $MSG_HAND, "#@errrec#", 
                  %{ "retry", "ignore" }, ret )
         if ret %== "retry" : goto playretry
         elif ret %== "ignore" : return  
      }    
   }
   procdeinit()
}

func playmacro( str filename, int speed, str srepeat )
{
   buf       inplay
   
   if !*filename : return
   defmacro.replace( filename )
   inplay.read( filename )
   
   playmacrodata( inplay, speed, srepeat )
}

