/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

type SHQUERYRBINFO
{
   uint cbSize     
   long i64Size
   long i64NumItems
}

import "shell32.dll"
{
   uint SHEmptyRecycleBinA( uint, uint, uint ) -> SHEmptyRecycleBin
   uint SHQueryRecycleBinA( uint, SHQUERYRBINFO ) -> SHQueryRecycleBin
}

define 
{
   SHERB_NOCONFIRMATION = 0x00000001
   SHERB_NOPROGRESSUI   = 0x00000002
   SHERB_NOSOUND        = 0x00000004   
}

func recbinempty( str drive )
{
   SHEmptyRecycleBin( 0, drive.ptr(), $SHERB_NOCONFIRMATION |
                      $SHERB_NOPROGRESSUI | $SHERB_NOSOUND )
}

func recbininfo( str drive, str var )
{
   arrstr paths
   SHQUERYRBINFO  bininfo
   long   size count
   
   if !*var : var = "recbin"
   bininfo.cbSize = sizeof( SHQUERYRBINFO )
   if *drive
   {
      SHQueryRecycleBin( drive.ptr(), bininfo )
      size = bininfo.i64Size
      count = bininfo.i64NumItems
   }
   else
   {
      arrstr alldrives
      
      alldrives = getdrives()
      foreach curd, alldrives
      {
         if getdrivetype( "\(curd)\\" ) == $DRIVE_FIXED
         { 
            SHQueryRecycleBin( curd.ptr(), bininfo )
            size += bininfo.i64Size
            count += bininfo.i64NumItems
         }
      }
   }
   defmacro.set( var, str( size ))
   defmacro.set( "\(var)num", str( count ))
}
