/******************************************************************************
*
* Copyright (C) 2009, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

type SECURITY_ATTRIBUTES 
{ 
  uint  nLength 
  uint  lpSecurityDescriptor 
  uint  bInheritHandle 
}

define
{ 
   DUPLICATE_CLOSE_SOURCE  = 0x00000001  
   DUPLICATE_SAME_ACCESS   = 0x00000002
   
   STARTF_USESTDHANDLES    = 0x00000100
   STARTF_USESHOWWINDOW    = 0x00000001
   CREATE_NEW_CONSOLE      = 0x00000010
   ERROR_BROKEN_PIPE       = 109
   ERROR_NO_DATA           = 232
   
   INVALID_HANDLE_VALUE  = -1
   STD_INPUT_HANDLE   = -10
   STD_OUTPUT_HANDLE  = -11
   STD_ERROR_HANDLE   = -12
}  

import "kernel32.dll"
{
   uint CreatePipe( uint, uint, SECURITY_ATTRIBUTES, uint )
   uint DuplicateHandle( uint, uint, uint, uint, uint, uint, uint )
   uint GetCurrentProcess()
   uint GetStdHandle( uint )
//   uint CreateThread( uint, uint, uint, uint, uint, uint )
//   uint WriteConsoleA( uint, uint, uint, uint, uint )->WriteConsole
//   uint ReadConsoleA( uint, uint, uint, uint, uint )->ReadConsole
}

global 
{
//   uint bRunThread
//   uint hStdIn
   uint hChildProcess
}

func uint redirectprocess( str cmdline workdir, 
                          uint hChildStdOut hChildStdIn hChildStdErr )
{
   PROCESS_INFORMATION pi
   STARTUPINFO si

   si.cb = sizeof(STARTUPINFO)
   si.dwFlags = $STARTF_USESTDHANDLES | $STARTF_USESHOWWINDOW
   si.hStdOutput = hChildStdOut
   si.hStdInput  = hChildStdIn
   si.hStdError  = hChildStdErr
   si.wShowWindow = $SW_HIDE;

   if !CreateProcess( 0, cmdline.ptr(), 0, 0, 1,
                       0/*  $CREATE_NEW_CONSOLE */, 0, 
                       ?( &workdir && *workdir, workdir.ptr(), 0 ), si, pi )
   {
      return 0
   }

   hChildProcess = pi.hProcess
   CloseHandle( pi.hThread )
   return 1
}

/*
func uint GetAndSendInputThread( uint lpvThreadParam )
{
   str stemp
   uint rw crw
   uint hPipeWrite = lpvThreadParam

   stemp.reserve( 4096 )
   // Get input from our console and send it to child through the pipe.
   while bRunThread
   {
       if !ReadConsole( hStdIn, stemp.ptr(), 1, &rw, 0 ) : error("ReadConsole")

       stemp.setlen( rw )

       if !WriteFile( hPipeWrite, stemp.ptr(), rw, &crw, 0 )
       {
          if GetLastError() == $ERROR_NO_DATA : break // Pipe was closed (normal exit path).
          else : error("WriteFile")
       }
   }

   return 1
}
*/

func uint ReadAndHandleOutput( uint hPipeRead, str out )
{
   uint rw //crw 
   str  stemp sout

   stemp.clear()
   stemp.reserve( 4096 )
   
   while 1
   {
       if !ReadFile( hPipeRead, stemp.ptr(), 4096,
                                          &rw, 0 ) || !rw 
       {
          if GetLastError() == $ERROR_BROKEN_PIPE : break // pipe done - normal exit path.
          else : return 0
       }
       stemp.setlen( rw )
//       stemp.char2oem()
       if &out : out += stemp
       else : sout += stemp
       if sout[ *sout - 1 ] == 0xA
       {
//         if *sout <=2 : sout.insert( 0, " " )
//         print( sout )
         outtext( sout )
         sout.clear()
       } 
//       if !WriteConsole( GetStdHandle( $STD_OUTPUT_HANDLE ), stemp.ptr(),
//                         rw, &crw, 0 ) : error("WriteConsole")
   }
   if *sout : outtext( sout )
   return 1
}

//-------------------------------------------------

func uint redircon( str cmdline workdir out )
{
   uint hOutReadTmp hOutWrite hOutRead
   uint hInWriteTmp hInRead hInWrite
   uint hError 
//   thread hthread //hThread ThreadId
   SECURITY_ATTRIBUTES sa

   sa.nLength= sizeof(SECURITY_ATTRIBUTES)
   sa.bInheritHandle = 1

   if !CreatePipe( &hOutReadTmp, &hOutWrite, sa, 0 ) : return 0
   if !DuplicateHandle( GetCurrentProcess(), hOutWrite, GetCurrentProcess(),
            &hError, 0, 1, $DUPLICATE_SAME_ACCESS ) : return 0
   if !CreatePipe( &hInRead, &hInWriteTmp, sa, 0 ) : return 0
   if !DuplicateHandle( GetCurrentProcess(),hOutReadTmp, GetCurrentProcess(),
         &hOutRead, 0, 0, $DUPLICATE_SAME_ACCESS ) : return 0
   if !DuplicateHandle( GetCurrentProcess(), hInWriteTmp, GetCurrentProcess(),
         &hInWrite, 0, 0, $DUPLICATE_SAME_ACCESS ) : return 0
   CloseHandle( hOutReadTmp )
   CloseHandle( hInWriteTmp )

/*   if ( hStdIn = GetStdHandle( $STD_INPUT_HANDLE )) ==
                                                $INVALID_HANDLE_VALUE
   {
      error("GetStdHandle")
   }*/
   redirectprocess( cmdline, workdir, hOutWrite, hInRead, hError )
   CloseHandle( hOutWrite)
   CloseHandle( hInRead ) 
   CloseHandle( hError ) 
  
/*   if !hthread.create( &GetAndSendInputThread, hInWrite )
   {
//   hThread = CreateThread( 0,0, GetAndSendInputThread,
//                              hInWrite, 0, &ThreadId )
      error("CreateThread")
   }*/
   ReadAndHandleOutput( hOutRead, out )

//   if !CloseHandle( hStdIn ) : error("CloseHandle")

//   bRunThread = 0
//   hthread.wait()
//   if (WaitForSingleObject(hThread,INFINITE) == WAIT_FAILED)
//         DisplayError("WaitForSingleObject");

   CloseHandle( hOutRead )
   CloseHandle( hInWrite )
   return 1 
}

func execon( str filename cmdline workdir redirtype varname )
{
   str cmd sret
   
   cmd = "\"\(filename)\""
   if *cmdline : cmd += " \(cmdline)"
   defmacro.set( "runok", 0 )
   defmacro.replace( workdir )
   defmacro.replace( cmd )
   
   if redircon( cmd, ?( *workdir, workdir, 0->str ), 
                  ?( redirtype == "script", 0->str, sret ) )
   {
      defmacro.set( "runok", 1 )
      if redirtype == "var" : defmacro.set( varname, sret )
   }
}

func scriptcon( str filename cmdline workdir redirtype varname )
{
   uint ret
   str cmd sret
   
   defmacro.set( "runok", 0 )
   
   if redirtype %== "gui" : cmd = "wscript.exe /nologo"    
   else : cmd = "cscript.exe /nologo"
   if !*filename : return
      
   cmd += " \"\(filename)\""
   if *cmdline : cmd += " \(cmdline)"
   
   defmacro.replace( workdir )
   defmacro.replace( cmd )
   if redirtype %== "gui" || redirtype %== "con"
   {
      uint wait 
      
      ret = process( cmd, workdir, &wait )
      defmacro.set( "runret", wait )
   }     
   else
   {
      if redircon( cmd, workdir, 
                  ?( redirtype == "script", 0->str, sret ) )
      {
         ret = 1
         if redirtype == "var" : defmacro.set( varname, sret )
      }
   }
   defmacro.set( "runok", ret )
}
