/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

define 
{
   REN_KEEP = 0x0001
   REN_DEL = 0x0002
}

func uint renamecmd( str filename dest newname, uint flag )
{
   str  name
   uint ret
   
   if !*filename || ( !*dest && !*newname ) : return 0
   
   defmacro.replace( filename )
   defmacro.replace( dest )
   defmacro.replace( newname )
 
   filename.ffullname( filename )
   
   if *dest
   { 
      if *newname : name = newname 
      else : name.fnameext( filename ) 
   }
   else
   { 
      dest.fgetdir( filename )
      name = newname
   }
   dest.faddname( name )

   dest.ffullname( dest )   

   label again      
   if flag & $REN_DEL && fileexist( dest ) && filename %!= dest
   { 
      deletefile( dest )
   }
   if flag & $REN_KEEP : ret = copyfile( filename, dest )
   else : ret = movefile( filename, dest )
   if !ret
   {
      if flag & $CMD_ERRMSG 
      {
         str ret = "msgdelret"
         
         message( $MSG_HAND, "#@errmove# \(dest)!", 
                  %{ "retry", "ignore" }, ret )
         if ret %== "retry" : goto again
         elif ret %== "ignore" : return 0  
      } 
   }
   elif flag & $CMD_LOGOUT
   {
      outtextnew( "#@renmove#: \(filename) => \( dest )" )
   }
   return 1  
}