/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

define
{
   REPF_WORDS = 0x0001          
}

func repfiles( str filename ignore, uint flag, uint dataoff )
{
   uint   ptr count repflag fflag = $FIND_FILE
   ffind  fd
   arrstr wcard
   
   count = getlistptr( dataoff, &ptr )
   if !count || !*filename : return

   if flag & $CMD_RECURSIVE : fflag |= $FIND_RECURSE 
   if flag & $REPF_WORDS : repflag = $QS_WORD

   defmacro.replace( filename )
   defmacro.replace( ignore )
   if *ignore : ignore.split( wcard, ',', $SPLIT_NOSYS )
   
   fd.init( filename, fflag )
   foreach cur, fd
   {
      uint ok skip i
      str  in
      uint  cptr = ptr
        
      foreach curn, wcard
      {
         if cur.name.fwildcard( curn ) 
         {
            skip = 1
            break
         } 
      }
      if skip : continue
      in.read( cur.fullname )
      fornum i, count
      {
         str   old new
         uint  off 
         spattern sp
     
         getlistval( old, &cptr )
         defmacro.replace( old )
         getlistval( new, &cptr )
         defmacro.replace( new )
         
         sp.init( old, repflag )
         while ( off = sp.search( in, off )) < *in
         {
            in.replace( off, *old, new )   
            ok++            
            off += *new            
         }
      }            
      if ok
      {
         if in.write( cur.fullname ) && flag & $CMD_LOGOUT
         {
            outtextnew( "#@replacefile# \(ok): \(cur.fullname)" )   
         }        
      } 
   }      
}
      