/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

define
{
   REPTXT_WORDS  = 0x0001          
   REPTXT_IGNORE = 0x0002
   REPTXT_SUBST  = 0x0004          
}

func replacetext( str varname, uint flag, uint dataoff )
{
   uint   i ptr count repflag ok
   str    in 
   
   count = getlistptr( dataoff, &ptr )
   if !count : return
   
   if flag & $REPTXT_SUBST : defmacro.get( varname, in )
   else : in = str( defmacro[ varname ] ) 
    
   if flag & $REPTXT_WORDS : repflag = $QS_WORD
   if flag & $REPTXT_IGNORE : repflag |= $QS_IGNCASE

   fornum i, count
   {
      str   old new
      uint  off 
      spattern sp
     
      getlistval( old, &ptr )
      defmacro.replace( old )
      getlistval( new, &ptr )
      defmacro.replace( new )
         
      sp.init( old, repflag )
      while ( off = sp.search( in, off )) < *in
      {
         in.replace( off, *old, new )   
         ok++            
         off += *new            
      }
   }            
   if ok : defmacro.set( varname, in )
}
      