/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

func run( str filename cmdline workdir, uint wait runas )
{
   str cmd sret
   uint ret runok
   
   cmd = "\"\(filename)\""
   if *cmdline : cmd += " \(cmdline)"
   defmacro.set( "runret", 0 )
//   process( cmd, ?( *workdir, workdir, 0->str ), ?( wait, &ret, 0 ))
   
   label again
   if wait
   {
      messagenfy( $MSG_NOTE, "#@rtmwait# \(filename)" )
   }
   defmacro.replace( workdir )
   defmacro.replace( cmd )
   runok = process( cmd, ?( *workdir, workdir, 0->str ), ?( wait, &ret, 0 ), runas )
   
   if !runok
   {
      message( $MSG_HAND, "#@rtmerrrun# \(filename)", 
               %{ "retry", "ignore", "abort" }, sret = "runerr" )
      if sret %== "ignore" : return
      elif sret %== "retry" : goto again
      elif sret %== "abort" : exit( 0 )
   }
   if wait
   { 
      messagenfy( $MSG_NOTE, "" )
      defmacro.set( "runret", ret )
   }
}