/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

include : "..\\libs\\clipboard.g"
include : "..\\libs\\bitmap.g"
include : "..\\libs\\winproc.g"

import "user32.dll"
{
   int ShowCursor( uint )
}

func screenshot( str match left top width height, uint clip, 
                 str dest filename )
{
   uint wnd hdc bhdc
   uint x y w h bmp oldbmp
   RECT rect
   str  bmpfile
   
   if !clip && !*filename : return
   
   switch match
   {
      case "desktop" :  wnd = GetDesktopWindow()
      case "active" :  wnd = GetForegroundWindow()
   }
	hdc = GetDC( 0 )
   GetWindowRect( wnd, rect )
      
   if *left : x = uint( left )
   if *top : y = uint( top )
   w = ?( *width, uint( width ), rect.right - rect.left )
   h = ?( *height, uint( height ), rect.bottom - rect.top )
   if w + x > rect.right - rect.left : w = rect.right - rect.left - x  
   if h + y > rect.bottom - rect.top : h = rect.bottom - rect.top - y  
   bhdc = CreateCompatibleDC( hdc )
   bmp = CreateCompatibleBitmap( hdc, w, h )
   oldbmp = SelectObject( bhdc, bmp )
   ShowCursor( 0 )
	BitBlt( bhdc, 0, 0, w, h, hdc, x + rect.left, y + rect.top, 
           $SRCCOPY | $CAPTUREBLT )
   ShowCursor( 1 )
   if *filename
   {
      ( bmpfile = dest ).faddname( filename )
      defmacro.replace( bmpfile )
      bmpfile.fsetext( "bmp" )
      savebmp( bmpfile, bmp )
   }
   if clip
   {
      OpenClipboard( 0 )
	   EmptyClipboard()
      SetClipboardData( $CF_BITMAP, bmp )
	   CloseClipboard()
   }
	SelectObject( bhdc, oldbmp )
 	DeleteDC( bhdc )
	DeleteObject( bmp )
}