/******************************************************************************
*
* Copyright (C) 2009, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

include : $"..\libs\smtp\smtp.g"

func uint sendemail( str host port user password from to subject body, 
                     uint flag )
{
   uint ok
   str  response
   smtp ismtp
   
   defmacro.replace( host )
   defmacro.replace( password )
   defmacro.replace( user )
   defmacro.replace( from )
   defmacro.replace( to )
   defmacro.replace( subject )
   defmacro.replace( body )

   inet_init()
   label again
   
   if ismtp.open( host, uint( port ), user, password, 0 )
   {
      ok = ismtp.send( from, to, subject, body, "" )
      response = ismtp.ni.head
      if ok && flag & $CMD_LOGOUT
      {
         outtextnew( "Email: \(from) => \(to): \(subject)" )
      }
      ismtp.close()
   }
   if !ok && flag & $CMD_ERRMSG 
   {
      str ret = "msgret"
      message( $MSG_HAND, "#@error# email [\( ismtp.ni.param 
               )] \(from) => \(to): \( response )", %{ "retry", "ignore" }, ret )
      if ret %== "retry" : goto again
      elif ret %== "ignore" : return 0  
   }   
   inet_close()
   
   return 1
}