/******************************************************************************
*
* Copyright (C) 2009, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

define
{
   SC_MANAGER_ALL_ACCESS = 0xF003F
   SERVICE_ALL_ACCESS	 = 0xf01ff
   SERVICE_CONTROL_STOP	 = 1
   SERVICE_DELETE        = 0x10000
   SERVICE_QUERY_CONFIG  = 1
   SERVICE_QUERY_STATUS	 = 4
   SERVICE_START			 = 0x10
   SERVICE_STOP		    = 0x20
   SERVICE_WIN32_OWN_PROCESS	 = 0x10
	SERVICE_WIN32_SHARE_PROCESS = 0x20
   SERVICE_BOOT_START          = 0
	SERVICE_SYSTEM_START        = 1
	SERVICE_AUTO_START          = 2
	SERVICE_DEMAND_START        = 3
	SERVICE_DISABLED            = 4
   SERVICE_RUNNING             = 4
}

type SERVICE_STATUS 
{ 
  uint dwServiceType 
  uint dwCurrentState 
  uint dwControlsAccepted 
  uint dwWin32ExitCode
  uint dwServiceSpecificExitCode 
  uint dwCheckPoint 
  uint dwWaitHint 
}  

type ENUM_SERVICE_STATUS 
{ 
   uint           lpServiceName
   uint           lpDisplayName
   SERVICE_STATUS ServiceStatus
}

import "advapi32.dll"
{
   uint CloseServiceHandle( uint )
   uint ControlService( uint, uint, SERVICE_STATUS )
/*   uint CreateServiceA( uint, uint, uint, uint, uint, uint, uint, uint,
     uint, uint, uint, uint, uint ) -> CreateService
 
     uint DeleteService( uint )
     uint EnumDependentServicesA( uint, uint, uint, uint, uint, uint
          )->EnumDependentServices
     uint GetServiceKeyNameA( uint, uint, uint, uint )->GetServiceKeyName
*/   
   uint OpenSCManagerA( uint, uint, uint ) -> OpenSCManager
   uint OpenServiceA( uint, uint, uint ) -> OpenService
   uint QueryServiceStatus( uint, SERVICE_STATUS ) 
   uint StartServiceA( uint, uint, uint ) -> StartService 
}

func uint opensrvmanager
{
	return OpenSCManager( 0, 0, $SC_MANAGER_ALL_ACCESS )
}

func uint isservice( str name )
{
   uint ret 
   uint hscm hserv

	if hscm = opensrvmanager()
   {
		if hserv = OpenService( hscm, name.ptr(), $SERVICE_QUERY_CONFIG )
      {
         ret = 1
         CloseServiceHandle( hserv )
      }
      CloseServiceHandle( hscm )
   }
   return ret
}
/*
func uint createservice( str filename name display desc, 
                          uint srvtype starttype )
{
   uint ret 
   uint hscm hserv

	if hscm = opensrvmanager()
   {
		if hserv = CreateService( hscm, name.ptr(), display.ptr(),
         $SERVICE_ALL_ACCESS, srvtype, starttype, 0, filename.ptr(),
         0,0,0,0,0 )
      {
         ret = 1
  			if *desc
         {
            regset( $HKEY_LOCAL_MACHINE, 
                "System\\CurrentControlSet\\Services\\\(name)", "Description",
                desc, $REG_SZ, 0 )
         }
         CloseServiceHandle( hserv )
      }
      CloseServiceHandle( hscm )
   }
   return ret
} 

func uint deleteservice( str name )
{
   uint ret 
   uint hscm hserv
   
	if hscm = opensrvmanager()
   {
		if hserv = OpenService( hscm, name.ptr(), $SERVICE_DELETE )
      {
         ret = DeleteService( hserv )
         CloseServiceHandle( hserv )
      }
      CloseServiceHandle( hscm )
   }
   return ret
}
*/
func uint startservice( str name )
{
   uint ret 
   uint hscm hserv

   if hscm = opensrvmanager()
   {
		if hserv = OpenService( hscm, name.ptr(), $SERVICE_START )
      {
         ret = StartService( hserv, 0, 0)
         CloseServiceHandle( hserv )
      }
      CloseServiceHandle( hscm )
   }
   return ret
   
}

func uint stopservice( str name )
{
   uint ret 
   uint hscm hserv
   SERVICE_STATUS  stat
   
   if hscm = opensrvmanager()
   {
		if hserv = OpenService( hscm, name.ptr(), $SERVICE_STOP )
      {
         ret = ControlService( hserv, $SERVICE_CONTROL_STOP, stat )
         CloseServiceHandle( hserv )
      }
      CloseServiceHandle( hscm )
   }
   return ret
}

func uint isservicerun( str name )
{
   uint ret 
   uint hscm hserv
   SERVICE_STATUS  stat
   
   if hscm = opensrvmanager()
   {
		if hserv = OpenService( hscm, name.ptr(), $SERVICE_QUERY_STATUS )
      {
			if QueryServiceStatus( hserv, stat )
         {
            ret = ( stat.dwCurrentState == $SERVICE_RUNNING )
         } 
         CloseServiceHandle( hserv )
      }
      CloseServiceHandle( hscm )
   }
   return ret
}
/*
func uint installservice( str filename name display desc, uint servtype )
{
   if !isservice( name )
   {
      if createservice( filename, name, display, desc, 
                          $SERVICE_WIN32_OWN_PROCESS, servtype )
      {
         Sleep( 1000 )
         startservice( name )
         return 1
      }
   }
   return 0
}*/
