/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

define
{
   FATT_READONLY = 0x0001          
   FATT_HIDDEN   = 0x0002          
   FATT_ARCHIVE  = 0x0004          
}

func setattrib( uint flag, uint dataoff )
{
   uint   ptr i count attrib fflag = $FIND_FILE
   
   count = getlistptr( dataoff, &ptr )
   if !count : return

   if flag & $FATT_READONLY : attrib = $FILE_ATTRIBUTE_READONLY 
   if flag & $FATT_HIDDEN : attrib |= $FILE_ATTRIBUTE_HIDDEN 
   if flag & $FATT_ARCHIVE : attrib |= $FILE_ATTRIBUTE_ARCHIVE 
   if !attrib : attrib = $FILE_ATTRIBUTE_NORMAL

   if flag & $CMD_RECURSIVE : fflag |= $FIND_RECURSE 

   fornum i, count
   {
      str   filename
      ffind fd
      
      getlistval( filename, &ptr )
      defmacro.replace( filename )
      fd.init( filename, fflag )
      foreach cur, fd
      { 
         if setfileattrib( cur.fullname, attrib ) && flag & $CMD_LOGOUT
         {
            outtextnew( "#@setattr#: 0x\(hex2stru( attrib )) => \( cur.fullname )" )
         }
      }            
   }      
}
      