/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

define
{
   EWX_LOGOFF       =    0
   EWX_SHUTDOWN     =    0x00000001
   EWX_FORCE        =    0x00000004
   SHTDN_REASON_MAJOR_APPLICATION = 0x00040000
   SHTDN_REASON_FLAG_PLANNED      = 0x80000000
} 

import "kernel32.dll"
{
   uint SetSystemPowerState( uint, uint )
}
/*
import "Powrprof.dll"
{
   uint SetSuspendState( uint, uint, uint )
}*/

func shutdown( uint action force )
{
   rebootNT()
   if action < 0x100
   { 
      ExitWindowsEx( action | ?( force, $EWX_FORCE, 0 ), 
         $SHTDN_REASON_MAJOR_APPLICATION | $SHTDN_REASON_FLAG_PLANNED )
   }
   else : SetSystemPowerState( action & 0xff, force )   
   
   ExitProcess( 0 )
}