/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

import "winmm.dll"
{
   uint PlaySoundA( uint, uint, uint ) -> PlaySound
}

define
{
   SND_SYNC   = 0x0000
   SND_ASYNC  = 0x0001 
   SND_NODEFAULT = 0x0002
   SND_MEMORY    = 0x0004  
   SND_LOOP      = 0x0008 
   SND_NOSTOP    = 0x0010
   SND_TEMP      = 0x1000

   SND_FILENAME  = 0x00020000
   SND_RESOURCE  = 0x00040004
}

func uint sound( str filename, uint wait loop )
{
   uint flags
   
   if !*filename : return PlaySound( 0, 0, $SND_NODEFAULT )
    
   if !wait : flags |= $SND_ASYNC
   if loop : flags |= $SND_LOOP
         
   defmacro.replace( filename )
   return PlaySound( filename.ptr(), 0, flags | $SND_FILENAME | 
                 /*$SND_ASYNC |*/ $SND_NODEFAULT )
}
         
