/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

define 
{
   SYNCMD_COPY    = 0x010
   SYNCMD_ASK     = 0x020
   SYNCMD_NDEL    = 0x040   
   SYNCMD_NCOPY   = 0x080
   SYNCMD_NASK    = 0x100
   SYNCMD_ERRIGNORE = 0x200
   SYNCMD_ERRONLY  = 0x400
   SYNCMD_READONLY = 0x800
   SYNCMD_DIFTIME  = 0x1000
}

type synchi
{
   byte      skip
   filetime  ft
}

// gentee!!!
func uint isemptydir( str dirname )
{
   ffind fd
 
   fd.init("\(dirname)\\*.*", $FIND_FILE | $FIND_DIR )
   foreach cur, fd : return 0  
   return 1  
}

func uint synchcmd( str left, uint lflag, str right, uint rflag, 
                    str wildcard ignore, uint flag )
{
   arrstr  wcards
   arrstr  ignors
   hash hleft of synchi
   hash hright of synchi
   str  ret

   subfunc synchload( hash out of synchi, str dir )
   {
      uint i
      
      dir.fdelslash()
      
      ffind fd
      str   fname
         
      ( fname = dir ).faddname( "*.*" )
      fd.init( fname, $FIND_FILE | $FIND_RECURSE )
      foreach finfo cur, fd
      {
         uint skip = 1 
         str  fkey
            
         foreach curw, wcards
         {
            if cur.name.fwildcard( curw ) 
            {
               skip = 0
               break
            } 
         }
         if skip : continue
         foreach curn, ignors
         {
            if cur.name.fwildcard( curn ) 
            {
               skip = 1
               break
            } 
         }
         if skip : continue
         ( fkey = cur.fullname ).del( 0, *dir + 1 )
         out[ fkey ].ft = cur.lastwrite
//         print("\(dir)\\\(fkey)\n") 
      } 
   }
   subfunc synchdirs( hash hl of synchi, str dleft, hash hr of synchi,
                      str dright, uint flags )
   {
      arrstr lkeys
      
      foreach lkeyh, hl.keys
      {
         if hl[ lkeyh ].skip : continue
         lkeys += lkeyh 
      }
      lkeys.sort( 1 )
      foreach lkey, lkeys
      {
         uint rkey iscopy 
         str  lname rname
   
         //hleft[ lkey ].skip = 1
         ( lname = dleft ).faddname( lkey )
         ( rname = dright ).faddname( lkey )
         if rkey = hr.find( lkey )
         {
            rkey as synchi
            
            if ( flags & $SYNCMD_COPY &&  
                CompareFileTime( rkey.ft, hl[ lkey ].ft ) < 0 ) ||
               ( flags & $SYNCMD_DIFTIME &&  
                CompareFileTime( rkey.ft, hl[ lkey ].ft ) != 0 )  
            {
               if flags & $SYNCMD_ASK
               {
                  ret = "msgqcopy" 
                  message( $MSG_QUEST, "#@qcopyf# \(lname)?", 
                     %{ "no", "noall", "yes", "yesall" }, ret )
                  if ret %== "yes" || ret %== "yesall" : iscopy = 1
                  if ret %== "noall"
                  {
                     flags &= ~$SYNCMD_COPY
                     flags &= ~$SYNCMD_ASK             
                  }
                  if ret %== "yesall" : flags &= ~$SYNCMD_ASK             
                  //   No Yes No All Yes All 
               }
               else : iscopy = 1  
               rkey.skip = 1
            }  
         }
         else
         {
            if flags & $SYNCMD_NDEL
            {
               if flags & $SYNCMD_NASK
               {
                  //   No Yes No All Yes All
                  ret = "msgqcopy"
                  message( $MSG_QUEST, "#@qdelf# \(lname)?", 
                        %{ "no", "noall", "yes", "yesall" }, ret )
                  if ret %== "noall"
                  {
                     flags &= ~$SYNCMD_NDEL
                     flags &= ~$SYNCMD_NASK             
                  }
                  if ret %== "yesall" : flags &= ~$SYNCMD_NASK             
                  if ret %== "no" || ret %== "noall" : continue
               } 
               label delagain
               if flag & $SYNCMD_READONLY
               {
                  setattribnormal( lname )
               }
               if !deletefile( lname ) 
               {
                  if flag & $CMD_ERRMSG
                  {
                     if flag & $SYNCMD_ERRIGNORE
                     {
                       outtextnew( "#@errdel# \(lname)!" )
                     }
                     else
                     {
                        ret = "msgdelret"
                        message( $MSG_HAND, "#@errdel# \(lname)!", 
                                 %{ "retry", "ignore" }, ret )
                        if ret %== "retry" : goto delagain
                     }
                  }
               }
               else
               {
                  str dirname
                  
                  dirname.fgetdir( lname )
                  if isemptydir( dirname )
                  { 
                     if flag & $SYNCMD_READONLY
                     {
                        setfileattrib( dirname, $FILE_ATTRIBUTE_DIRECTORY )
                     }
                     deletedir( dirname )
                  }                  
                  if flag & $CMD_LOGOUT && !( flag & $SYNCMD_ERRONLY )
                  {  
                     outtextnew( "#@delete#: \( lname )" )   
                  }
               } 
               continue 
            }   
            if flags & $SYNCMD_NCOPY
            {
               if flags & $SYNCMD_NASK
               {
                  ret = "msgqcopy"
                  message( $MSG_QUEST, "#@qcopyf# \(lname)?", 
                  %{ "no", "noall", "yes", "yesall" }, ret )
                  if ret %== "yes" || ret %== "yesall" : iscopy = 1
                  if ret %== "noall"
                  {
                     flags &= ~$SYNCMD_NCOPY
                     flags &= ~$SYNCMD_NASK             
                  }
                  if ret %== "yesall" : flags &= ~$SYNCMD_NASK             
                  //   No Yes No All Yes All 
               }
               else : iscopy = 1  
            }
         }
         if iscopy
         {
            str dir
            
            dir.fgetdir( rname )
            verifypath( dir, 0->arrstr )
            label writeretry
            if flag & $SYNCMD_READONLY
            {
               setattribnormal( rname )
            }
            if !copyfile( lname, rname ) 
            {         
               if flag & $CMD_ERRMSG
               {
                  if flag & $SYNCMD_ERRIGNORE
                  {
                    outtextnew( "#@errwrite# \(rname)!" )
                  }
                  else
                  {
                     ret = "msgdelret"
                     message( $MSG_HAND, "#@errwrite# \(rname)!",
                           %{ "retry", "ignore" }, ret )
                     if ret %== "retry" : goto writeretry
                  }
               }
            }
            elif flag & $CMD_LOGOUT && !( flag & $SYNCMD_ERRONLY )
            {
               outtextnew( "#@copy#: \(lname) => \(rname)")
            }
         }
      }
   }      
                  
   if !*left || !*right : return 0
   defmacro.replace( left )
   defmacro.replace( right )
   defmacro.replace( ignore )
   defmacro.replace( wildcard )
   if !*wildcard : wildcard = "*.*"

   hleft.ignorecase()
   hright.ignorecase()

   wildcard.split( wcards, ',', $SPLIT_NOSYS )   
   if *ignore : ignore.split( ignors, ',', $SPLIT_NOSYS )

   synchload( hleft, left )
   synchload( hright, right )

   synchdirs( hleft, left, hright, right, lflag )
   synchdirs( hright, right, hleft, left, rflag )      
   return 1
}