/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project 
* http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES
* RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

// gentee!!!
import "kernel32.dll"
{
   uint SetLocalTime( datetime )
}

// gentee!!!
method uint datetime.settime()
{
   datetime dt
   uint     i
   
   dt.gettime()
   if .second != 0xFFFF : dt.second = .second  % 60
   if .minute != 0xFFFF : dt.minute = .minute  % 60
   if .hour != 0xFFFF : dt.hour = .hour % 24
   if .day != 0xFFFF
   { 
      i = .day
      if i >= 1 && i <= 31 : dt.day = i 
   }
   if .month != 0xFFFF
   { 
      i = .month
      if i >= 1 && i <= 12 : dt.month = i 
   }
   if .year != 0xFFFF
   { 
      i = .year
      if i >= 1601 && i <= 30827 : dt.year = i 
   }
   SetLocalTime( dt )   
   return SetLocalTime( dt ) != 0   
}

func setsystime( str sec minute hour day month year ) 
{
   datetime dt

   dt.second = ?( *sec, uint( sec ), 0xFFFF )   
   dt.minute = ?( *minute, uint( minute ), 0xFFFF )
   dt.hour = ?( *hour, uint( hour ), 0xFFFF )
   dt.day = ?( *day, uint( day ), 0xFFFF )
   dt.month = ?( *month, uint( month ), 0xFFFF )
   dt.year = ?( *year, uint( year ), 0xFFFF )
   dt.settime()
}
