/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of Perfect Automation software 
* http://www.perfectautomation.com
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE 
* ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
* CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

define
{
   ANSIUTF = 1
   ANSIUTFP
   UTFANSI
   UTFPREF = "﻿" 
}

func textconv( str varname, uint convmode )
{
   str  value stemp
   ustr utemp
   
   defmacro.get( varname, value )
   switch convmode
   {
      case $ANSIUTF, $ANSIUTFP :ustr( value ).toutf8( stemp )
      case $UTFANSI
      { 
         if $UTFPREF.eqlen( value ) : value.del( 0, 3 )
         stemp = str( utemp.fromutf8( value ))
      }
   }
   if convmode == $ANSIUTFP : defmacro.set( varname, "\$UTFPREF\(stemp)" )
   else : defmacro.set( varname, stemp ) 
}