/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/
/*
import "hook.dll"<link>
{
   hookstart( uint )
   hookstop()     
}
*/
import "user32.dll"
{
   uint VkKeyScanA( uint ) -> VkKeyScan
}

func uint waitthread( uint param )
{
   while 1
   {
      Sleep( 100 )
   }
   return 0
}

func wait( str waittype, str value )
{
   datetime  dt shift
   uint      i hookid
   arrstr    val
   
   defmacro.replace( value )
   if waittype == "hotkey"
   {
      value.split( val, '+', $SPLIT_NOSYS | $SPLIT_EMPTY )
      if *val == 1
      {
         val.clear()
         value.split( val, '-', $SPLIT_NOSYS | $SPLIT_EMPTY )
      }
      waitkey = 0
      foreach cur, val
      {
         if cur %== "Ctrl" : waitkey |= $KEY_KEYCTRL
         elif cur %== "Alt" : waitkey |= $KEY_KEYALT
         elif cur %== "Shift" : waitkey |= $KEY_KEYSHIFT
         elif cur %== "Win" : waitkey |= $KEY_KEYWIN
         else
         {
            if *cur == 1
            {
               waitkey |= VkKeyScan( cur[0] ) & 0xFF               
            }
            else
            {
               fornum i =1, 13
               { 
                  if cur %== "F\(i)"
                  {
                     waitkey |= 0x70 + ( i - 1 )
                     break
                  }
               }
            }
         }
      }
   }
   else
   {
      value.split( val, ':', $SPLIT_NOSYS | $SPLIT_EMPTY )
      i = *val - 1
      dt.gettime()
      if waittype == "pause"
      {
         shift.second = uint( val[ i ] )
         if i : shift.minute = uint( val[ --i ] )
         if i : shift.hour = uint( val[ --i ] )
         dt += shift
      }
      else
      {
         dt.hour = uint( val[ 0 ] )
         if i > 0 : dt.minute = uint( val[1] )      
         if i > 1 : dt.second = uint( val[2] )
         dt.normalize()         
      }
   }
   switch ( waittype )
   {
      case "pause","till"
      {
         str sdate stime
         getdatetime( dt, sdate, stime ) 
         messagenfy( $MSG_NOTE, "#@rtmwaittill#: \(sdate) \(stime)" )
         do 
         {
            shift.gettime()
            Sleep( 500 )
         } while shift < dt
         messagenfy( $MSG_NOTE, "" )
      }
      case "hotkey"
      {
         messagenfy( $MSG_NOTE, "#@rtmwaittill#: \(value)" )
         procinit( 0 )
         hookid = keyhook( mainwnd, waitkey )
//         hookstart( mainwnd )
         waitth.create( &waitthread, 0 )
         waitth.wait()  
         keyunhook( hookid )
//         hookstop()
         procdeinit()
         messagenfy( $MSG_NOTE, "" )
      }
   }
}
