/******************************************************************************
*
* Copyright (C) 2008, Gentee, Inc. All rights reserved. 
* This file is part of the Perfect Automation project - http://www.perfectautomation.com. 
* 
* THIS FILE IS PROVIDED UNDER THE TERMS OF THE PERFECT AUTOMATION LICENSE ("AGREEMENT"). 
* ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE CONSTITUTES RECIPIENTS 
* ACCEPTANCE OF THE AGREEMENT.
*
* Author: Alexey Krivonogov ( gentee )
*
******************************************************************************/

include : "..\\libs\\winproc.g"

import "user32.dll"
{
   uint AttachThreadInput( uint, uint, uint )
}

func uint forceforeground( uint hwnd, uint state )
{ 
   uint self result
   uint foreground = GetWindowThreadProcessId( GetForegroundWindow(), 0 )

   if  !hwnd || !IsWindow(hwnd) : return 0

   self = GetWindowThreadProcessId( hwnd, 0 )
   if  foreground != self 
   {
//      AttachThreadInput( foreground, self, 1 )
      AttachThreadInput( self, foreground, 1 )
      result = SetForegroundWindow( hwnd )
      ShowWindow( hwnd, 5 )
      BringWindowToTop( hwnd )
      AttachThreadInput( self, foreground, 0 )
//      AttachThreadInput( foreground, self, 0 )
   }
   else : result = SetForegroundWindow( hwnd )
   if IsIconic( hwnd )
   { 
      ShowWindow( hwnd, $SW_RESTORE )
      if state != $SW_SHOW && !IsZoomed( hwnd ) : ShowWindow( hwnd, state )
   }
   else : ShowWindow( hwnd, state )
   return result
}

func uint enumwinactivate( uint wnd, twinmatch twin )
{
   if winmatch( wnd, twin )
   {
      if forceforeground( wnd, twin.state )
      {
         return 0
      }
   } 
   return 1
}

func uint winactivate( str name, str match, str state, str classname )
{
   twinmatch twin

   defmacro.replace( name )
   if *classname : defmacro.replace( classname )
   elif !*name : return 1
   twin.name = name
   twin.match = match
//   twin.hidden = 1
   twin.state = ?( state %== "max", $SW_MAXIMIZE, $SW_SHOW )
   twin.class = classname
   if match %== "exact"
   {
      uint wnd
      if wnd = FindWindow( ?( *classname, ustr( classname ).ptr(), 0 ), 
                           ?( *name, ustr( name ).ptr(), 0 ) )
      {
         forceforeground( wnd, twin.state )
      }
   }
   else : winenum( 0, &enumwinactivate, &twin )
   return 1
}
