#include=clear
 
define
{
	DESIGNING = 0
   COMP = 0   
}

global
{
   uint   g_threadfunc
   thread g_thread
   uint   g_autoshut
}

include {  
   $"logwin.gf"
}

include : "outtext.g"

func script_finish()
{
   LogForm.Close.Caption = ustr( "close" )
   LogForm.Close.Image = ustr( "resource\\BOK" )

   if LogForm.chAutoclose.Visible && LogForm.chAutoclose.Checked
   {
      PostMessage( mainwnd, $WM_COMMAND, $CMD_AUTOCLOSE, 0 )
   } 
   elif IsIconic( mainwnd ) || !IsWindowVisible( mainwnd )
   {
      ShowWindow( mainwnd, $SW_RESTORE )
   }
}


func script_run( uint threadfunc )
{
   str dir
   uint gti

   gettempdir( dir )
   
   g_threadfunc = threadfunc
   
   g_lang.write( "\(dir)\\\$LANG.lng")
   
   App.ImgM.LoadRes( "", "resource", 0 )
   App.Lng.load( dir, $LANG, $LANG )
   gti as App.Lng.find("default")
   
   foreach  curg, gti
   {
      defmacro.setutf8( "@\( curg.name )", curg.value )
   }
   App.Load()
   switch $STATE
   {
      case 1 : LogForm.WindowState = $wsMaximized
      case 2 : LogForm.WindowState = $wsMinimized
      case 3 : LogForm.Visible = 0
   } 
   LogForm.Owner = App
   App.Run()
   if g_autoshut
   {
      rebootNT()
      ExitWindowsEx( $EWX_POWEROFF,
         0x00040000 | 0x80000000 ) 
//         $SHTDN_REASON_MAJOR_APPLICATION | $SHTDN_REASON_FLAG_PLANNED  
   }
}
